<?php
namespace Mainto\Bridge\Invokes\UserAuth;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method batchSendTemplateMessageByParams(array $params)
 * @method batchUserDeletedByParams(array $params)
 */
class Message {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 模板消息推送
     *
     * @param  string $taskId 任务ID [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function batchSendTemplateMessage (string $taskId) {
        return self::getClass()->batchSendTemplateMessage([
            "taskId" => $taskId,
        ]);
    }

    /**
     * 用户删除
     *
     * @param  array $userIds 用户ids [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function batchUserDeleted (array $userIds) {
        return self::getClass()->batchUserDeleted([
            "userIds" => $userIds,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('UserAuth', 'Message');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('UserAuth', 'Message');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}