<?php
namespace Mainto\Bridge\Invokes\UserAuth\Rpc;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method appOneLoginByParams(array|\Mainto\Bridge\Structs\UserAuth\Rpc\Cmd\LocalVerification\AppOneLoginCmd $params)
 * @method h5LocalVerificationByParams(array|\Mainto\Bridge\Structs\UserAuth\Rpc\Cmd\LocalVerification\H5LocalVerificationCmd $params)
 */
class LocalVerification {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * app端一键登录
     *
     * @var  \Mainto\Bridge\Structs\UserAuth\Rpc\Cmd\LocalVerification\AppOneLoginCmd $appOneLoginCmd
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\UserAuth\Rpc\DTO\LocalVerification\InsensitiveVerificationDTO
     */
    public static function appOneLogin (\Mainto\Bridge\Structs\UserAuth\Rpc\Cmd\LocalVerification\AppOneLoginCmd $appOneLoginCmd) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->appOneLogin($appOneLoginCmd),
            "\Mainto\Bridge\Structs\UserAuth\Rpc\DTO\LocalVerification\InsensitiveVerificationDTO"
        );
    }


    /**
     * h5 本机校验
     *
     * @var  \Mainto\Bridge\Structs\UserAuth\Rpc\Cmd\LocalVerification\H5LocalVerificationCmd $H5LocalVerificationCmd
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\UserAuth\Rpc\DTO\LocalVerification\InsensitiveVerificationDTO
     */
    public static function h5LocalVerification (\Mainto\Bridge\Structs\UserAuth\Rpc\Cmd\LocalVerification\H5LocalVerificationCmd $H5LocalVerificationCmd) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->h5LocalVerification($H5LocalVerificationCmd),
            "\Mainto\Bridge\Structs\UserAuth\Rpc\DTO\LocalVerification\InsensitiveVerificationDTO"
        );
    }


    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('UserAuth', 'Rpc\LocalVerification');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('UserAuth', 'Rpc\LocalVerification');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}