<?php
namespace Mainto\Bridge\Invokes\UserAuth\Rpc;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getAuthSessionInfoByParams(array $params)
 */
class Session {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取当前session用户id和过期时间
     *
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\UserAuth\Rpc\DTO\UserSession\UserSessionDTO
     */
    public static function getAuthSessionInfo () {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getAuthSessionInfo(),
            "\Mainto\Bridge\Structs\UserAuth\Rpc\DTO\UserSession\UserSessionDTO"
        );
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('UserAuth', 'Rpc\Session');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('UserAuth', 'Rpc\Session');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}