<?php
namespace Mainto\Bridge\Invokes\UserAuth\Rpc;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method adaptVerificationByParams(array|\Mainto\Bridge\Structs\UserAuth\Rpc\Cmd\AdaptVerification\AdaptVerificationCmd $params)
 */
class AdaptVerification {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 适应性验证
     *
     * @var  \Mainto\Bridge\Structs\UserAuth\Rpc\Cmd\AdaptVerification\AdaptVerificationCmd $adaptVerificationCmd
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\UserAuth\Rpc\DTO\AdaptVerification\AdaptVerificationDTO
     */
    public static function adaptVerification (\Mainto\Bridge\Structs\UserAuth\Rpc\Cmd\AdaptVerification\AdaptVerificationCmd $adaptVerificationCmd) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->adaptVerification($adaptVerificationCmd),
            "\Mainto\Bridge\Structs\UserAuth\Rpc\DTO\AdaptVerification\AdaptVerificationDTO"
        );
    }


    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('UserAuth', 'Rpc\AdaptVerification');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('UserAuth', 'Rpc\AdaptVerification');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}