<?php
namespace Mainto\Bridge\Invokes\UserAuth;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method serveGetByParams(array $params)
 * @method servePostByParams(array $params)
 * @method mantuHomeServeGetByParams(array $params)
 * @method mantuHomeServePostByParams(array $params)
 * @method showPicWxHandleGetByParams(array $params)
 * @method showPicWxHandlePostByParams(array $params)
 * @method himoGoldHandleGetByParams(array $params)
 * @method himoGoldHandlePostByParams(array $params)
 * @method himoKidsHandleGetByParams(array $params)
 * @method himoKidsHandlePostByParams(array $params)
 * @method mantuHandleGetByParams(array $params)
 * @method mantuHandlePostByParams(array $params)
 * @method mantuBeautyPostByParams(array $params)
 * @method mantuBeautyGetByParams(array $params)
 * @method mantuQyWechatGetByParams(array $params)
 * @method mantuQyWechatPostByParams(array $params)
 */
class WxCallback {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * serveGet
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function serveGet () {
        return self::getClass()->serveGet();
    }

    /**
     * servePost
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function servePost () {
        return self::getClass()->servePost();
    }

    /**
     * mantuHomeServeGet
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function mantuHomeServeGet () {
        return self::getClass()->mantuHomeServeGet();
    }

    /**
     * mantuHomeServePost
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function mantuHomeServePost () {
        return self::getClass()->mantuHomeServePost();
    }

    /**
     * showPicWxHandleGet
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function showPicWxHandleGet () {
        return self::getClass()->showPicWxHandleGet();
    }

    /**
     * showPicWxHandlePost
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function showPicWxHandlePost () {
        return self::getClass()->showPicWxHandlePost();
    }

    /**
     * 海马体大师
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function himoGoldHandleGet () {
        return self::getClass()->himoGoldHandleGet();
    }

    /**
     * 海马体大师
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function himoGoldHandlePost () {
        return self::getClass()->himoGoldHandlePost();
    }

    /**
     * 海马体kids
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function himoKidsHandleGet () {
        return self::getClass()->himoKidsHandleGet();
    }

    /**
     * 海马体kids
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function himoKidsHandlePost () {
        return self::getClass()->himoKidsHandlePost();
    }

    /**
     * 缦图摄影
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function mantuHandleGet () {
        return self::getClass()->mantuHandleGet();
    }

    /**
     * 缦图摄影
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function mantuHandlePost () {
        return self::getClass()->mantuHandlePost();
    }

    /**
     * 缦图美妆
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function mantuBeautyPost () {
        return self::getClass()->mantuBeautyPost();
    }

    /**
     * 缦图美妆
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function mantuBeautyGet () {
        return self::getClass()->mantuBeautyGet();
    }

    /**
     * 企业微信回调
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function mantuQyWechatGet () {
        return self::getClass()->mantuQyWechatGet();
    }

    /**
     * 企业微信回调
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function mantuQyWechatPost () {
        return self::getClass()->mantuQyWechatPost();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('UserAuth', 'WxCallback');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('UserAuth', 'WxCallback');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}