<?php
namespace Mainto\Bridge\Invokes\UserAuth\Rpc;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method tokenCheckByParams(array|\Mainto\Bridge\Structs\UserAuth\Rpc\Cmd\Token\TokenCheckCmd $params)
 * @method createThirdIdentifyTempTokenByParams(array|\Mainto\Bridge\Structs\UserAuth\Rpc\Cmd\Token\Code2SessionCmd $params)
 */
class Token {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * token 校验
     *
     * @var  \Mainto\Bridge\Structs\UserAuth\Rpc\Cmd\Token\TokenCheckCmd $tokenCheckCmd
     * @throws  \Exception
     * @return  bool
     */
    public static function tokenCheck (\Mainto\Bridge\Structs\UserAuth\Rpc\Cmd\Token\TokenCheckCmd $tokenCheckCmd) {
        return self::getClass()->tokenCheck($tokenCheckCmd);
    }


    /**
     * 根据code获取临时token
     *
     * @var  \Mainto\Bridge\Structs\UserAuth\Rpc\Cmd\Token\Code2SessionCmd $code2SessionCmd
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\UserAuth\Rpc\DTO\Token\Code2SessionDTO
     */
    public static function createThirdIdentifyTempToken (\Mainto\Bridge\Structs\UserAuth\Rpc\Cmd\Token\Code2SessionCmd $code2SessionCmd) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->createThirdIdentifyTempToken($code2SessionCmd),
            "\Mainto\Bridge\Structs\UserAuth\Rpc\DTO\Token\Code2SessionDTO"
        );
    }


    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('UserAuth', 'Rpc\Token');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('UserAuth', 'Rpc\Token');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}