<?php
namespace Mainto\Bridge\Invokes\UserAuth\Rpc;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method userAuthListByParams(array|\Mainto\Bridge\Structs\UserAuth\Rpc\Cmd\UserAuth\UserAuthListCmd $params)
 */
class UserAuth {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取用户鉴权信息
     *
     * @var  \Mainto\Bridge\Structs\UserAuth\Rpc\Cmd\UserAuth\UserAuthListCmd $userAuthListCmd
     * @throws  \Exception
     * @return  mixed
     */
    public static function userAuthList (\Mainto\Bridge\Structs\UserAuth\Rpc\Cmd\UserAuth\UserAuthListCmd $userAuthListCmd) {
        return self::getClass()->userAuthList($userAuthListCmd);
    }


    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('UserAuth', 'Rpc\UserAuth');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('UserAuth', 'Rpc\UserAuth');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}