<?php
namespace Mainto\Bridge\Invokes\UserAuth\Rpc;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method code2SessionByParams(array|\Mainto\Bridge\Structs\UserAuth\Rpc\Cmd\ByteDance\Code2SessionCmd $params)
 * @method getTokenByByteDanceCodeByParams(array|\Mainto\Bridge\Structs\UserAuth\Rpc\Cmd\ByteDance\Code2SessionCmd $params)
 */
class DouYin {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 根绝code获取用户的临时token
     *
     * @var  \Mainto\Bridge\Structs\UserAuth\Rpc\Cmd\ByteDance\Code2SessionCmd $code2SessionCmd
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\UserAuth\Rpc\DTO\DouYin\Code2SessionDTO
     */
    public static function code2Session (\Mainto\Bridge\Structs\UserAuth\Rpc\Cmd\ByteDance\Code2SessionCmd $code2SessionCmd) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->code2Session($code2SessionCmd),
            "\Mainto\Bridge\Structs\UserAuth\Rpc\DTO\DouYin\Code2SessionDTO"
        );
    }


    /**
     * 根绝抖音小程序code获取登录token
     *
     * @var  \Mainto\Bridge\Structs\UserAuth\Rpc\Cmd\ByteDance\Code2SessionCmd $code2SessionCmd
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\UserAuth\Rpc\DTO\DouYin\LoginTokenByDouYinDTO
     */
    public static function getTokenByByteDanceCode (\Mainto\Bridge\Structs\UserAuth\Rpc\Cmd\ByteDance\Code2SessionCmd $code2SessionCmd) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getTokenByByteDanceCode($code2SessionCmd),
            "\Mainto\Bridge\Structs\UserAuth\Rpc\DTO\DouYin\LoginTokenByDouYinDTO"
        );
    }


    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('UserAuth', 'Rpc\DouYin');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('UserAuth', 'Rpc\DouYin');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}