<?php
namespace Mainto\Bridge\Invokes\UserAuth;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method loginByPassByParams(array $params)
 * @method loginByPwdByParams(array $params)
 * @method wxLoginByPhoneByParams(array $params)
 * @method getTokenByTempByParams(array $params)
 * @method getTempTokenByCodeByParams(array $params)
 * @method loginByTokenByParams(array $params)
 * @method getOpenIdByTokenByParams(array $params)
 * @method bindOAuthIdByParams(array $params)
 * @method logoutByParams(array $params)
 * @method getAuthInfoByIdByParams(array $params)
 * @method getAuthExpireTimeByParams(array $params)
 * @method getUserPermissionByParams(array $params)
 * @method wxAppLoginByEncryptedByParams(array $params)
 * @method bindUserWechatByCodeByParams(array $params)
 * @method loginByOpenIdByParams(array $params)
 * @method loginByAppleTokenByParams(array $params)
 * @method getTokenFromAppByParams(array $params)
 * @method getUserDeviceByUserIdByParams(array $params)
 * @method getOpenIdByCodeByParams(array $params)
 * @method code2SessionByCodeByParams(array $params)
 * @method alipayMiniLoginByEncryptedByParams(array $params)
 * @method loginByCodeByAlipayMiniByParams(array $params)
 * @method sendSmsWithTempTokenByParams(array $params)
 */
class Auth {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 通过用户名&amp;密码登录
     *
     * @param  string $phone 用户手机号 [ require true ]
     * @param  string $pass 密码 [ require true ]
     * @support  string $brand 品牌ID [ require true ]
     * @param  string $temp_token 临时token [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function loginByPass (string $phone, string $pass, string $temp_token = '') {
        return self::getClass()->loginByPass([
            "phone" => $phone,
            "pass" => $pass,
            "temp_token" => $temp_token,
        ]);
    }

    /**
     * 通过用户名&amp;密码登录 校验token
     *
     * @param  string $phone 用户手机号 [ require true ]
     * @param  string $pass 密码 [ require true ]
     * @support  string $brand 品牌ID [ require true ]
     * @param  string $tempToken 临时token [ require false ]
     * @param  string $token token验证 [ require true ]
     * @param  string $tokenType token类型 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function loginByPwd (string $phone, string $pass, string $token, string $tokenType, string $tempToken = '') {
        return self::getClass()->loginByPwd([
            "phone" => $phone,
            "pass" => $pass,
            "token" => $token,
            "tokenType" => $tokenType,
            "tempToken" => $tempToken,
        ]);
    }

    /**
     * 微信公众号登录-手机验证码
     *
     * @support  string $brand 项目源 [ require true ]
     * @support  string $phone 手机号 [ require true ]
     * @support  string $caption 手机验证码 [ require true ]
     * @support  string $temp_token temp_token [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function wxLoginByPhone () {
        return self::getClass()->wxLoginByPhone([
        ]);
    }

    /**
     * 通过临时token换取token
     *
     * @param  string $brand 品牌ID [ require true ]
     * @param  string $temp_token 临时token [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getTokenByTemp (string $brand, string $temp_token) {
        return self::getClass()->getTokenByTemp([
            "brand" => $brand,
            "temp_token" => $temp_token,
        ]);
    }

    /**
     * 通过小程序code换取temp_token
     *
     * @param  string $brand 品牌ID [ require true ]
     * @param  string $code 小程序code [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getTempTokenByCode (string $brand, string $code) {
        return self::getClass()->getTempTokenByCode([
            "brand" => $brand,
            "code" => $code,
        ]);
    }

    /**
     * 通过token登陆
     *
     * @param  string $token 系统颁发token [ require true ]
     * @param  string $brand 品牌ID [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function loginByToken (string $token, string $brand) {
        return self::getClass()->loginByToken([
            "token" => $token,
            "brand" => $brand,
        ]);
    }

    /**
     * 根据token获取openid
     *
     * @param  string $token 用户token [ require true ]
     * @param  string $brand brand [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getOpenIdByToken (string $token, string $brand = null) {
        return self::getClass()->getOpenIdByToken([
            "token" => $token,
            "brand" => $brand,
        ]);
    }

    /**
     * 绑定第三方OAuth用户标示
     *
     * @param  int $type 第三方类别 [ require true ]
     * @param  string $openId 第三方用户标示 [ require true ]
     * @support  string $headImg 第三方用户头像 [ require false ]
     * @param  string $brand 品牌ID [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function bindOAuthId (int $type, string $openId, string $brand) {
        return self::getClass()->bindOAuthId([
            "type" => $type,
            "openId" => $openId,
            "brand" => $brand,
        ]);
    }

    /**
     * 退出登录
     *
     * @support  string $token 用户token [ require false ]
     * @support  string $brand 退出的平台 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function logout () {
        return self::getClass()->logout([
        ]);
    }

    /**
     * 根据登录ID获取权限(此接口用于网关获取登录状态)
     *
     * @param  string $auth_id session id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getAuthInfoById (string $auth_id) {
        return self::getClass()->getAuthInfoById([
            "auth_id" => $auth_id,
        ]);
    }

    /**
     * 获取当前session过期时间
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function getAuthExpireTime () {
        return self::getClass()->getAuthExpireTime();
    }

    /**
     * 获取当前用户权限
     *
     * @param  string $prefix 前缀 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getUserPermission (string $prefix = '') {
        return self::getClass()->getUserPermission([
            "prefix" => $prefix,
        ]);
    }

    /**
     * 微信小程序登录-使用加密数据
     *
     * @support  string $brand 项目源 [ require true ]
     * @support  string $mobile_encrypt 手机加密值 [ require true ]
     * @support  string $mobile_iv 手机iv [ require true ]
     * @support  string $temp_token temp_token [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function wxAppLoginByEncrypted () {
        return self::getClass()->wxAppLoginByEncrypted([
        ]);
    }

    /**
     * 根据code绑定品牌用户
     *
     * @param  string $code code [ require true ]
     * @param  string $brand 品牌 [ require true ]
     * @param  int $userId 用户id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function bindUserWechatByCode (string $code, string $brand, int $userId) {
        return self::getClass()->bindUserWechatByCode([
            "code" => $code,
            "brand" => $brand,
            "userId" => $userId,
        ]);
    }

    /**
     * 微信三方登录-海马体app
     *
     * @support  string $phone 用户手机号，用户需要注册时传递手机号 [ require false ]
     * @support  string $brand 品牌ID，app：mantu_app [ require true ]
     * @support  string $openId 微信openid [ require true ]
     * @support  string $caption 手机验证码 [ require false ]
     * @support  string $accessToken 微信accessToken，使用accessToken+openId做登录校验 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function loginByOpenId () {
        return self::getClass()->loginByOpenId([
        ]);
    }

    /**
     * 苹果账户三方登录
     *
     * @support  string $phone 用户手机号，用户需要注册时传递手机号 [ require false ]
     * @support  string $caption 手机验证码 [ require false ]
     * @support  string $identityToken 苹果校验jwt token [ require true ]
     * @support  string $brand 品牌ID，app：mantu_app [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function loginByAppleToken () {
        return self::getClass()->loginByAppleToken([
        ]);
    }

    /**
     * app端获取token
     *
     * @support  string $brand 品牌ID [ require false ]
     * @support  string $deviceToken 友盟设备token [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getTokenFromApp () {
        return self::getClass()->getTokenFromApp([
        ]);
    }

    /**
     * 通过userId获取友盟设备号
     *
     * @param  int $userId 用户id [ require true ]
     * @param  string $brand 品牌ID [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getUserDeviceByUserId (int $userId, string $brand = 'mantu_app') {
        return self::getClass()->getUserDeviceByUserId([
            "userId" => $userId,
            "brand" => $brand,
        ]);
    }

    /**
     * 通过小程序code获取openID
     *
     * @param  string $code 小程序code [ require true ]
     * @param  string $brand 品牌 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getOpenIdByCode (string $code, string $brand) {
        return self::getClass()->getOpenIdByCode([
            "code" => $code,
            "brand" => $brand,
        ]);
    }

    /**
     * 通过小程序code获取openID和unionID
     *
     * @param  string $code 小程序code [ require true ]
     * @param  string $brand 品牌 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function code2SessionByCode (string $code, string $brand) {
        return self::getClass()->code2SessionByCode([
            "code" => $code,
            "brand" => $brand,
        ]);
    }

    /**
     * 支付宝小程序登录-使用加密数据
     *
     * @support  string $brand 项目源 [ require true ]
     * @support  string $decryptData 加密值 [ require true ]
     * @support  string $tempToken temp_token [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function alipayMiniLoginByEncrypted () {
        return self::getClass()->alipayMiniLoginByEncrypted([
        ]);
    }

    /**
     * 通过支付宝小程序code登录
     *
     * @support  string $code 支付宝小程序code [ require false ]
     * @support  string $brand 品牌ID [ require false ]
     * @support  string $phone 用户手机号，用户需要注册时传递手机号-暂不使用 [ require false ]
     * @support  string $tempToken temp token [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function loginByCodeByAlipayMini () {
        return self::getClass()->loginByCodeByAlipayMini([
        ]);
    }

    /**
     * 发送短信并校验鉴权temp-token
     *
     * @param  string $brand 品牌ID [ require true ]
     * @param  string $phone 手机号 [ require true ]
     * @param  string $tempToken 登录鉴权-temptoken [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function sendSmsWithTempToken (string $brand, string $phone, string $tempToken) {
        return self::getClass()->sendSmsWithTempToken([
            "brand" => $brand,
            "phone" => $phone,
            "tempToken" => $tempToken,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('UserAuth', 'Auth');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('UserAuth', 'Auth');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}