<?php
namespace Mainto\Bridge\Invokes\UserAuth;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method addByParams(array $params)
 * @method updateByParams(array $params)
 * @method deleteByParams(array $params)
 * @method listByParams(array $params)
 * @method logsByParams(array $params)
 * @method logsCountByParams(array $params)
 * @method channelQrcodeByParams(array $params)
 * @method getChannelLogsByParams(array $params)
 */
class Channel {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 新增渠道
     *
     * @param  string $name 渠道名称 [ require true ]
     * @param  string $brand 品牌(himo,himo_gold,mantu,himo_kids,himo_lens,himo_business,mantu_show_pic) [ require true ]
     * @param  int $channelNum 渠道号 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function add (string $name, string $brand, int $channelNum) {
        return self::getClass()->add([
            "name" => $name,
            "brand" => $brand,
            "channelNum" => $channelNum,
        ]);
    }

    /**
     * 更新渠道信息
     *
     * @param  int $id 渠道id [ require true ]
     * @param  string $name 渠道名称 [ require false ]
     * @param  string $brand 品牌(himo,mantu,himo_kids,himo_lens,himo_business) [ require false ]
     * @param  int $channelNum 渠道号 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function update (int $id, int $channelNum = 0, string $name = '', string $brand = '') {
        return self::getClass()->update([
            "id" => $id,
            "channelNum" => $channelNum,
            "name" => $name,
            "brand" => $brand,
        ]);
    }

    /**
     * 删除渠道
     *
     * @param  int $id 渠道id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function delete (int $id) {
        return self::getClass()->delete([
            "id" => $id,
        ]);
    }

    /**
     * 渠道号列表
     *
     * @support  string $name 渠道名称 [ require false ]
     * @support  string $brand 品牌(himo,mantu,himo_kids,himo_lens,himo_business) [ require false ]
     * @support  int $channelNum 渠道号 [ require false ]
     * @support  int $page 页码 [ require false ]
     * @support  int $pageSize 每页条数 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function list ($context) {
        return self::getClass()->list([
            "context" => $context,
        ]);
    }

    /**
     * 获取渠道日志
     * @deprecated
     *
     * @support  int $id 渠道id [ require true ]
     * @support  bool $fromSubscribe 来自新注册用户 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function logs ($context) {
        return self::getClass()->logs([
            "context" => $context,
        ]);
    }

    /**
     * 获取渠道日志计数
     *
     * @param  array $ids 渠道ids [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function logsCount (array $ids) {
        return self::getClass()->logsCount([
            "ids" => $ids,
        ]);
    }

    /**
     * 获取渠道二维码
     *
     * @param  int $id 渠道id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function channelQrcode (int $id) {
        return self::getClass()->channelQrcode([
            "id" => $id,
        ]);
    }

    /**
     * 获取关注列表-分页
     *
     * @support  int $channelId 渠道ID [ require false ]
     * @support  array $channelIds 渠道IDs [ require false ]
     * @support  string $openId 微信openid [ require false ]
     * @support  string $brand 平台 [ require false ]
     * @support  bool $fromSubscribe 来自新注册用户 [ require false ]
     * @support  string $createdAtStart 起始时间,Y-m-d H:i:s [ require false ]
     * @support  string $createdAtEnd 结束时间Y-m-d H:i:s [ require false ]
     * @param  int $page 分页 [ require false ]
     * @param  int $pageSize 页码 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getChannelLogs ($context, int $page = 1, int $pageSize = 10) {
        return self::getClass()->getChannelLogs([
            "context" => $context,
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('UserAuth', 'Channel');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('UserAuth', 'Channel');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}