<?php
namespace Mainto\Bridge\Invokes\UserAuth;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getAuthsByParams(array $params)
 * @method getUserDevicesByParams(array $params)
 * @method getUserDeviceInfoByParams(array $params)
 * @method getAuthInfoByUserIdByParams(array $params)
 * @method getAuthInfoByThirdIdentityIdByParams(array $params)
 */
class AuthBase {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取登录鉴权信息
     *
     * @support  int $userId 用户ID [ require false ]
     * @support  array $userIds 用户IDs [ require false ]
     * @support  string $brand 平台 [ require false ]
     * @support  array $brands 平台s [ require false ]
     * @support  bool $isLogin 是否登录 [ require false ]
     * @support  string $thirdIdentifyId 第三方认证Id【wxopenid|alipayuserid】 [ require false ]
     * @support  array $thirdIdentifyIds 第三方认证Ids【wxopenid|alipayuserid】 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getAuths ($context) {
        return self::getClass()->getAuths([
            "context" => $context,
        ]);
    }

    /**
     * 获取app登录设备关联信息
     *
     * @support  string $brand 平台 [ require false ]
     * @support  array $brands 平台s [ require false ]
     * @support  int $userId 用户ID [ require false ]
     * @support  array $userIds 用户IDs [ require false ]
     * @support  string $deviceToken 友盟token [ require false ]
     * @support  array $deviceTokens 友盟tokens [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getUserDevices ($context) {
        return self::getClass()->getUserDevices([
            "context" => $context,
        ]);
    }

    /**
     * 获取用户关联device信息
     *
     * @support  string $brand 平台 [ require true ]
     * @support  int $userId 用户ID [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getUserDeviceInfo ($context) {
        return self::getClass()->getUserDeviceInfo([
            "context" => $context,
        ]);
    }

    /**
     * 获取用户鉴权信息
     *
     * @param  int $userId 用户id [ require true ]
     * @param  string $brand 品牌 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getAuthInfoByUserId (int $userId, string $brand) {
        return self::getClass()->getAuthInfoByUserId([
            "userId" => $userId,
            "brand" => $brand,
        ]);
    }

    /**
     * 根据第三方证牌获取鉴权信息
     * @deprecated
     *
     * @param  string $thirdIdentityId 第三方证牌 [ require true ]
     * @param  string $brand 品牌id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getAuthInfoByThirdIdentityId (string $thirdIdentityId, string $brand) {
        return self::getClass()->getAuthInfoByThirdIdentityId([
            "thirdIdentityId" => $thirdIdentityId,
            "brand" => $brand,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('UserAuth', 'AuthBase');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('UserAuth', 'AuthBase');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}