<?php
namespace Mainto\Bridge\Invokes\UserAuth;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getExternalContactListByParams(array $params)
 * @method getExternalContactInfoByParams(array $params)
 */
class QyWechat {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取客户列表
     *
     * @param  string $qyUserid 企业微信成员ID [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getExternalContactList (string $qyUserid) {
        return self::getClass()->getExternalContactList([
            "qyUserid" => $qyUserid,
        ]);
    }

    /**
     * 获取客户列表
     *
     * @param  string $externalUserid 外部联系人的userid [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getExternalContactInfo (string $externalUserid) {
        return self::getClass()->getExternalContactInfo([
            "externalUserid" => $externalUserid,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('UserAuth', 'QyWechat');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('UserAuth', 'QyWechat');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}