<?php
namespace Mainto\Bridge\Invokes\UserAuth;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getAuthUrlByParams(array $params)
 * @method authByCodeByParams(array $params)
 * @method afterAuthGetUserInfoByParams(array $params)
 * @method createMemberCardByParams(array $params)
 * @method updateMemberInfoByParams(array $params)
 * @method checkWxCallbackForMantuHomeByParams(array $params)
 * @method checkWxCallbackForMantuByParams(array $params)
 * @method checkWxCallbackForHimoByParams(array $params)
 * @method checkWxCallbackForKidsByParams(array $params)
 */
class WechatOAuth {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取微信认证跳转Url
     *
     * @param  string $brand 品牌ID [ require true ]
     * @param  string $scopes 鉴权类型 [ require false ]
     * @param  string $url 回跳地址 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getAuthUrl (string $brand, string $url, string $scopes = 'snsapi_userinfo') {
        return self::getClass()->getAuthUrl([
            "brand" => $brand,
            "url" => $url,
            "scopes" => $scopes,
        ]);
    }

    /**
     * 通过Code获取微信用户信息
     *
     * @param  string $code 微信返回的鉴权码 [ require true ]
     * @param  string $state 微信返回标记值 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function authByCode (string $code, string $state) {
        return self::getClass()->authByCode([
            "code" => $code,
            "state" => $state,
        ]);
    }

    /**
     * 登录后获取用户数据
     *
     * @param  string $temp_token temp_token [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function afterAuthGetUserInfo (string $temp_token) {
        return self::getClass()->afterAuthGetUserInfo([
            "temp_token" => $temp_token,
        ]);
    }

    /**
     * 创建会员卡
     *
     * @param  array $cardInfo 会员卡信息设置 [ require false ]
     * @param  string $scene 品牌ID [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function createMemberCard (string $scene, array $cardInfo = []) {
        return self::getClass()->createMemberCard([
            "scene" => $scene,
            "cardInfo" => $cardInfo,
        ]);
    }

    /**
     * 更新会员卡积分
     *
     * @param  string $scene 品牌ID [ require true ]
     * @param  string $cardId 会员卡ID [ require true ]
     * @param  string $cardCode 会员卡Code [ require true ]
     * @param  string $note 积分明细 [ require true ]
     * @param  int $integral 积分[可为负数] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function updateMemberInfo (string $scene, string $cardId, string $cardCode, string $note, int $integral) {
        return self::getClass()->updateMemberInfo([
            "scene" => $scene,
            "cardId" => $cardId,
            "cardCode" => $cardCode,
            "note" => $note,
            "integral" => $integral,
        ]);
    }

    /**
     * 微信校验回调地址-缦图之家
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function checkWxCallbackForMantuHome () {
        return self::getClass()->checkWxCallbackForMantuHome();
    }

    /**
     * 微信校验回调地址-缦图
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function checkWxCallbackForMantu () {
        return self::getClass()->checkWxCallbackForMantu();
    }

    /**
     * 微信校验回调地址-海马体
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function checkWxCallbackForHimo () {
        return self::getClass()->checkWxCallbackForHimo();
    }

    /**
     * 微信校验回调地址-kids
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function checkWxCallbackForKids () {
        return self::getClass()->checkWxCallbackForKids();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('UserAuth', 'WechatOAuth');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('UserAuth', 'WechatOAuth');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}