<?php
namespace Mainto\Bridge\Invokes\UserAuth;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getAuthsByParams(array $params)
 * @method getUserDevicesByParams(array $params)
 * @method getUserDeviceInfoByParams(array $params)
 * @method getAuthInfoByHimoidByParams(array $params)
 * @method getAuthInfoByThirdIdentityIdByParams(array $params)
 * @method geUserRelatedAuthInfoByParams(array $params)
 */
class AuthBase {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取登录鉴权信息
     *
     * @support  int $userId 用户ID [Original type uint] 
     * @support  array $userIds 用户IDs 
     * @support  string $brand 平台 
     * @support  array $brands 平台s 
     * @support  bool $isLogin 是否登录 
     * @support  string $thirdIdentifyId 第三方认证Id【wxopenid|alipayuserid】 
     * @support  array $thirdIdentifyIds 第三方认证Ids【wxopenid|alipayuserid】 
     * @throws  \Exception
     * @return  mixed
     */
    public static function getAuths () {
        return self::getClass()->getAuths();
    }

    /**
     * 获取app登录设备关联信息
     *
     * @support  string $brand 平台 
     * @support  array $brands 平台s 
     * @support  int $userId 用户ID [Original type uint] 
     * @support  array $userIds 用户IDs 
     * @support  string $deviceToken 友盟token 
     * @support  array $deviceTokens 友盟tokens 
     * @throws  \Exception
     * @return  mixed
     */
    public static function getUserDevices () {
        return self::getClass()->getUserDevices();
    }

    /**
     * 获取用户关联device信息
     *
     * @support  string $brand 平台 [ require true ]
     * @support  int $userId 用户ID [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getUserDeviceInfo () {
        return self::getClass()->getUserDeviceInfo();
    }

    /**
     * 获取用户鉴权信息
     *
     * @param  int $himoid 用户id [Original type uint] [ require true ]
     * @param  int $brand 品牌 [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getAuthInfoByHimoid (int $himoid, int $brand) {
        return self::getClass()->getAuthInfoByHimoid([
            "himoid" => $himoid,
            "brand" => $brand,
        ]);
    }

    /**
     * 根据第三方证牌获取鉴权信息
     * @deprecated
     *
     * @param  string $thirdIdentityId 第三方证牌 [ require true ]
     * @param  string $brand 品牌id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getAuthInfoByThirdIdentityId (string $thirdIdentityId, string $brand) {
        return self::getClass()->getAuthInfoByThirdIdentityId([
            "thirdIdentityId" => $thirdIdentityId,
            "brand" => $brand,
        ]);
    }

    /**
     * 获取用户登录信息
     * @deprecated
     *
     * @param  int $userId 用户ID [Original type uint] [ require true ]
     * @param  string $brand 平台 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function geUserRelatedAuthInfo (int $userId, string $brand) {
        return self::getClass()->geUserRelatedAuthInfo([
            "userId" => $userId,
            "brand" => $brand,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('UserAuth', 'AuthBase');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('UserAuth', 'AuthBase');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}