<?php
namespace Mainto\Bridge\Invokes\UserAuth;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method newThirdWechatAuthByParams(array $params)
 * @method getH5SignByParams(array $params)
 */
class ThirdWechat {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 新建第三方证书
     *
     * @param  string $startUsageTime 开始使用时间 [ require true ]
     * @param  string $stopUsageTime 结束使用时间 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function newThirdWechatAuth (string $startUsageTime = NULL, string $stopUsageTime = NULL) {
        return self::getClass()->newThirdWechatAuth([
            "startUsageTime" => $startUsageTime,
            "stopUsageTime" => $stopUsageTime,
        ]);
    }

    /**
     * getH5Sign
     *
     * @param  string $scene 项目 [ require true ]
     * @param  string $url 页面当前地址 [ require true ]
     * @param  bool $debug 调试模式 [ require true ]
     * @param  string $key 密钥key,调取凭证 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getH5Sign (string $scene, string $url, string $key, bool $debug = false) {
        return self::getClass()->getH5Sign([
            "scene" => $scene,
            "url" => $url,
            "key" => $key,
            "debug" => $debug,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('UserAuth', 'ThirdWechat');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('UserAuth', 'ThirdWechat');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}