<?php
namespace Mainto\Bridge\Invokes\UserAuth;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getTokenByCodeByParams(array $params)
 * @method decryptPhoneNoByParams(array $params)
 */
class AlipayAuth {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 根据code换取授权访问令牌
     * @deprecated
     *
     * @param  string $code code [ require true ]
     * @param  string $brand 品牌 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getTokenByCode (string $code, string $brand) {
        return self::getClass()->getTokenByCode([
            "code" => $code,
            "brand" => $brand,
        ]);
    }

    /**
     * 解密
     *
     * @support  string $payload 解密字符串 [ require true ]
     * @support  string $brand 品牌 
     * @support  bool $isNeedLogin 是否是登录 
     * @throws  \Exception
     * @return  string
     */
    public static function decryptPhoneNo () {
        return self::getClass()->decryptPhoneNo();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('UserAuth', 'AlipayAuth');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('UserAuth', 'AlipayAuth');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}