<?php
namespace Mainto\Bridge\Invokes\UserAuth;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method geUserRelatedAuthInfoByParams(array $params)
 * @method getAuthsByParams(array $params)
 */
class AuthBase {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取用户登录信息
     *
     * @param  int $userId 用户ID [Original type uint] [ require true ]
     * @param  string $brand 平台 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function geUserRelatedAuthInfo (int $userId, string $brand) {
        return self::getClass()->geUserRelatedAuthInfo([
            "userId" => $userId,
            "brand" => $brand,
        ]);
    }

    /**
     * 获取登录鉴权信息
     *
     * @support  int $userId 用户ID [Original type uint] 
     * @support  array $userIds 用户IDs 
     * @support  string $brand 平台 
     * @support  array $brands 平台s 
     * @support  bool $isLogin 是否登录 
     * @support  string $thirdIdentifyId 第三方认证Id【wxopenid|alipayuserid】 
     * @support  array $thirdIdentifyIds 第三方认证Ids【wxopenid|alipayuserid】 
     * @throws  \Exception
     * @return  mixed
     */
    public static function getAuths () {
        return self::getClass()->getAuths();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('UserAuth', 'AuthBase');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('UserAuth', 'AuthBase');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}