<?php
namespace Mainto\Bridge\Invokes\UserAuth;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getJssdkByParams(array $params)
 * @method getApiTicketByParams(array $params)
 * @method getAccessTokenByParams(array $params)
 * @method getWxCardExtFieldByParams(array $params)
 * @method receiveCardLogByParams(array $params)
 * @method consumeWxCardCodeByParams(array $params)
 * @method decryptWxCardCodeByParams(array $params)
 * @method sendTemplateMsgByParams(array $params)
 * @method sendTemplateMsgByWxAppByParams(array $params)
 * @method sendSubscribeMsgByWxAppByParams(array $params)
 * @method sendKfMsgByParams(array $params)
 * @method sendKfMsgAllTypeByParams(array $params)
 * @method checkWxCardCodeByParams(array $params)
 * @method getMaterialListByParams(array $params)
 * @method serveGetByParams(array $params)
 * @method servePostByParams(array $params)
 * @method mantuHomeServeGetByParams(array $params)
 * @method mantuHomeServePostByParams(array $params)
 * @method showPicWxHandleGetByParams(array $params)
 * @method showPicWxHandlePostByParams(array $params)
 * @method himoGoldHandleGetByParams(array $params)
 * @method himoGoldHandlePostByParams(array $params)
 * @method himoKidsHandleGetByParams(array $params)
 * @method himoKidsHandlePostByParams(array $params)
 * @method mantuHandleGetByParams(array $params)
 * @method mantuHandlePostByParams(array $params)
 * @method genQrcodeByParams(array $params)
 * @method checkUserSubscribeByParams(array $params)
 * @method batchGetUserSubscribeByParams(array $params)
 * @method getUserListByParams(array $params)
 * @method getWechatInfoByCodeByParams(array $params)
 * @method uploadImageByParams(array $params)
 * @method getWechatInfoByOpenIdByParams(array $params)
 */
class Wx {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 微信获取jssdk配置
     *
     * @param  string $scene 项目 [ require true ]
     * @param  string $url 页面当前地址 [ require true ]
     * @param  bool $debug 调试模式 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getJssdk (string $scene, string $url, bool $debug = false) {
        return self::getClass()->getJssdk([
            "scene" => $scene,
            "url" => $url,
            "debug" => $debug,
        ]);
    }

    /**
     * 获取api ticket
     *
     * @param  string $scene 项目 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getApiTicket (string $scene) {
        return self::getClass()->getApiTicket([
            "scene" => $scene,
        ]);
    }

    /**
     * 获取accessToken
     *
     * @param  string $scene 项目 [ require true ]
     * @support  string $token token 
     * @throws  \Exception
     * @return  array
     */
    public static function getAccessToken (string $scene) {
        return self::getClass()->getAccessToken([
            "scene" => $scene,
        ]);
    }

    /**
     * 生成微信卡券CardExt
     *
     * @param  string $scene 应用 [ require true ]
     * @param  string $code 卡券code [ require true ]
     * @param  string $openid openid [ require true ]
     * @param  string $card_id 卡券id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getWxCardExtField (string $scene, string $code = '', string $openid = '', string $card_id = '') {
        return self::getClass()->getWxCardExtField([
            "scene" => $scene,
            "code" => $code,
            "openid" => $openid,
            "card_id" => $card_id,
        ]);
    }

    /**
     * 领取记录
     *
     * @param  string $brand 应用 [ require true ]
     * @param  int $himoid 海马体id [Original type uint] [ require true ]
     * @param  string $code 卡券code [ require true ]
     * @param  string $card_id 卡券id [ require true ]
     * @param  string $openid openid [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function receiveCardLog (string $brand, int $himoid, string $code, string $card_id, string $openid = '') {
        return self::getClass()->receiveCardLog([
            "brand" => $brand,
            "himoid" => $himoid,
            "code" => $code,
            "card_id" => $card_id,
            "openid" => $openid,
        ]);
    }

    /**
     * 核销微信卡券code
     *
     * @param  string $scene 应用 [ require true ]
     * @param  string $code code [ require true ]
     * @param  string $cardId card_id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function consumeWxCardCode (string $scene, string $code, string $cardId) {
        return self::getClass()->consumeWxCardCode([
            "scene" => $scene,
            "code" => $code,
            "cardId" => $cardId,
        ]);
    }

    /**
     * 解密微信卡券Code
     *
     * @param  string $scene code [ require true ]
     * @param  string $encryptCode 加密的数据 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function decryptWxCardCode (string $scene, string $encryptCode) {
        return self::getClass()->decryptWxCardCode([
            "scene" => $scene,
            "encryptCode" => $encryptCode,
        ]);
    }

    /**
     * 发送模板消息
     *
     * @param  string $template_id 模板id [ require true ]
     * @param  array $data 参数数据 [ require true ]
     * @param  int $type id类型 1用户id 2用户手机号 3openid [ require true ]
     * @param  string $id 可以是手机号 openid 用户id,根据type识别 [ require true ]
     * @param  string $app_name 应用名称 [ require true ]
     * @param  string $url 点击跳转的链接 [ require true ]
     * @param  array $miniProgram 跳转小程序 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function sendTemplateMsg (int $type, string $id, string $app_name, string $template_id, array $data = [], string $url = '', array $miniProgram = []) {
        return self::getClass()->sendTemplateMsg([
            "type" => $type,
            "id" => $id,
            "app_name" => $app_name,
            "template_id" => $template_id,
            "data" => $data,
            "url" => $url,
            "miniProgram" => $miniProgram,
        ]);
    }

    /**
     * 发送微信小程序模板消息
     *
     * @param  string $template_id 模板id [ require true ]
     * @param  string $form_id 表单ID|支付ID [ require true ]
     * @param  array $data 参数数据 [ require true ]
     * @param  string $id 可以是手机号 openid 用户id,根据type识别 [ require true ]
     * @param  string $app_name 应用名称 [ require true ]
     * @param  string $page 小程序跳转页 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function sendTemplateMsgByWxApp (string $id, string $app_name, string $template_id, string $form_id, array $data = [], string $page = '') {
        return self::getClass()->sendTemplateMsgByWxApp([
            "id" => $id,
            "app_name" => $app_name,
            "template_id" => $template_id,
            "form_id" => $form_id,
            "data" => $data,
            "page" => $page,
        ]);
    }

    /**
     * 发送小程序订阅消息
     *
     * @param  string $id 可以是手机号 openid 用户id,根据type识别 [ require true ]
     * @param  int $type id类型 1用户id 2用户手机号 3openid [ require true ]
     * @param  string $template_id 模板id [ require true ]
     * @param  string $miniprogram_state 小程序版本 [ require true ]
     * @param  array $data 参数数据 [ require true ]
     * @param  string $app_name 应用名称 [ require true ]
     * @param  string $page 小程序跳转页 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function sendSubscribeMsgByWxApp (int $type, string $id, string $app_name, string $template_id, array $data = [], string $miniprogram_state = '', string $page = '') {
        return self::getClass()->sendSubscribeMsgByWxApp([
            "type" => $type,
            "id" => $id,
            "app_name" => $app_name,
            "template_id" => $template_id,
            "data" => $data,
            "miniprogram_state" => $miniprogram_state,
            "page" => $page,
        ]);
    }

    /**
     * 发送微信客服消息 （仅支持字符串）
     * @deprecated
     *
     * @param  int $type id类型 1用户id 2用户手机号 3openid [ require true ]
     * @param  string $id 可以是手机号 openid 用户id,根据type识别 [ require true ]
     * @param  string $app_name 应用名称 [ require true ]
     * @param  string $content 发送消息 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function sendKfMsg (int $type, string $id, string $app_name, string $content) {
        return self::getClass()->sendKfMsg([
            "type" => $type,
            "id" => $id,
            "app_name" => $app_name,
            "content" => $content,
        ]);
    }

    /**
     * 发送微信客服消息 (支持所有格式)
     *
     * @param  int $type id类型 1用户id 2用户手机号 3openid [ require true ]
     * @param  string $id 可以是手机号 openid 用户id,根据type识别 [ require true ]
     * @param  string $app_name 应用名称 [ require true ]
     * @param  array $content 发送消息 [ require true ]
     * @param  int $msgType 消息类型 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function sendKfMsgAllType (int $type, string $id, string $app_name, array $content, int $msgType = 1) {
        return self::getClass()->sendKfMsgAllType([
            "type" => $type,
            "id" => $id,
            "app_name" => $app_name,
            "content" => $content,
            "msgType" => $msgType,
        ]);
    }

    /**
     * 获取微信卡券Code状态信息
     *
     * @param  string $scene 应用 [ require true ]
     * @param  string $code code [ require true ]
     * @param  string $cardId card_id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function checkWxCardCode (string $scene, string $code, string $cardId) {
        return self::getClass()->checkWxCardCode([
            "scene" => $scene,
            "code" => $code,
            "cardId" => $cardId,
        ]);
    }

    /**
     * 获取永久素材列表
     *
     * @param  string $app_name 应用名称 [ require true ]
     * @param  string $type 素材类型(image,video,voice,news) [ require true ]
     * @param  int $offset 从该偏移位置开始返回 [ require true ]
     * @param  int $count 返回素材的数量(1-20) [ require true ]
     * @throws  \Exception
     * @return  string
     */
    public static function getMaterialList (string $app_name, string $type, int $offset = 0, int $count = 20) {
        return self::getClass()->getMaterialList([
            "app_name" => $app_name,
            "type" => $type,
            "offset" => $offset,
            "count" => $count,
        ]);
    }

    /**
     * serveGet
     *
     * @throws  \Exception
     * @return  string
     */
    public static function serveGet () {
        return self::getClass()->serveGet();
    }

    /**
     * servePost
     *
     * @throws  \Exception
     * @return  string
     */
    public static function servePost () {
        return self::getClass()->servePost();
    }

    /**
     * mantuHomeServeGet
     *
     * @throws  \Exception
     * @return  string
     */
    public static function mantuHomeServeGet () {
        return self::getClass()->mantuHomeServeGet();
    }

    /**
     * mantuHomeServePost
     *
     * @throws  \Exception
     * @return  string
     */
    public static function mantuHomeServePost () {
        return self::getClass()->mantuHomeServePost();
    }

    /**
     * showPicWxHandleGet
     *
     * @throws  \Exception
     * @return  string
     */
    public static function showPicWxHandleGet () {
        return self::getClass()->showPicWxHandleGet();
    }

    /**
     * showPicWxHandlePost
     *
     * @throws  \Exception
     * @return  string
     */
    public static function showPicWxHandlePost () {
        return self::getClass()->showPicWxHandlePost();
    }

    /**
     * 海马体大师
     *
     * @throws  \Exception
     * @return  string
     */
    public static function himoGoldHandleGet () {
        return self::getClass()->himoGoldHandleGet();
    }

    /**
     * 海马体大师
     *
     * @throws  \Exception
     * @return  string
     */
    public static function himoGoldHandlePost () {
        return self::getClass()->himoGoldHandlePost();
    }

    /**
     * 海马体kids
     *
     * @throws  \Exception
     * @return  string
     */
    public static function himoKidsHandleGet () {
        return self::getClass()->himoKidsHandleGet();
    }

    /**
     * 海马体kids
     *
     * @throws  \Exception
     * @return  string
     */
    public static function himoKidsHandlePost () {
        return self::getClass()->himoKidsHandlePost();
    }

    /**
     * 缦图摄影
     *
     * @throws  \Exception
     * @return  string
     */
    public static function mantuHandleGet () {
        return self::getClass()->mantuHandleGet();
    }

    /**
     * 缦图摄影
     *
     * @throws  \Exception
     * @return  string
     */
    public static function mantuHandlePost () {
        return self::getClass()->mantuHandlePost();
    }

    /**
     * 生成二维码
     *
     * @param  string $app_name 应用名称 [ require true ]
     * @param  string $key 二维码key值 [ require true ]
     * @throws  \Exception
     * @return  string
     */
    public static function genQrcode (string $app_name, string $key = '') {
        return self::getClass()->genQrcode([
            "app_name" => $app_name,
            "key" => $key,
        ]);
    }

    /**
     * 检查用户是否关注公众号
     *
     * @param  string $app_name 应用名称 [ require true ]
     * @param  string $open_id open_id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function checkUserSubscribe (string $app_name, string $open_id) {
        return self::getClass()->checkUserSubscribe([
            "app_name" => $app_name,
            "open_id" => $open_id,
        ]);
    }

    /**
     * 批量获取用户信息
     *
     * @param  string $appName 应用名称 [ require true ]
     * @param  array $openIds open_ids [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function batchGetUserSubscribe (string $appName, array $openIds) {
        return self::getClass()->batchGetUserSubscribe([
            "appName" => $appName,
            "openIds" => $openIds,
        ]);
    }

    /**
     * 获取用户列表
     *
     * @param  string $appName 应用名称 [ require true ]
     * @param  string $nextOpenId 从该openId下一个用户开始 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getUserList (string $appName, string $nextOpenId = '') {
        return self::getClass()->getUserList([
            "appName" => $appName,
            "nextOpenId" => $nextOpenId,
        ]);
    }

    /**
     * 根据微信Code获取微信信息
     *
     * @param  string $app_name 应用名称 [ require true ]
     * @param  string $code 微信code [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getWechatInfoByCode (string $app_name, string $code) {
        return self::getClass()->getWechatInfoByCode([
            "app_name" => $app_name,
            "code" => $code,
        ]);
    }

    /**
     * 上传永久素材图片
     *
     * @param  string $img_path 图片地址 [ require true ]
     * @param  string $app_name 应用名称 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function uploadImage (string $img_path, string $app_name) {
        return self::getClass()->uploadImage([
            "img_path" => $img_path,
            "app_name" => $app_name,
        ]);
    }

    /**
     * 根据openid获取用户信息
     *
     * @param  string $app_name 应用名称 [ require true ]
     * @param  string $open_id open id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getWechatInfoByOpenId (string $app_name, string $open_id) {
        return self::getClass()->getWechatInfoByOpenId([
            "app_name" => $app_name,
            "open_id" => $open_id,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('UserAuth', 'Wx');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('UserAuth', 'Wx');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}