<?php
namespace Mainto\Bridge\Invokes\UserAuth;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method addByParams(array $params)
 * @method updateByParams(array $params)
 * @method listByParams(array $params)
 * @method deleteByParams(array $params)
 * @method logsByParams(array $params)
 * @method logsCountByParams(array $params)
 * @method channelQrcodeByParams(array $params)
 * @method getSubscribeUserListByParams(array $params)
 */
class Channel {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 新增渠道
     *
     * @param  string $name 渠道名称 [ require true ]
     * @param  string $brand 品牌(himo,mantu,himo_kids,himo_lens,himo_business,mantu_show_pic) [ require true ]
     * @param  int $channelNum 渠道号 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function add (string $name, string $brand, int $channelNum) {
        return self::getClass()->add([
            "name" => $name,
            "brand" => $brand,
            "channelNum" => $channelNum,
        ]);
    }

    /**
     * 更新渠道信息
     *
     * @param  int $id 渠道id [ require true ]
     * @param  string $name 渠道名称 [ require true ]
     * @param  string $brand 品牌(himo,mantu,himo_kids,himo_lens,himo_business) [ require true ]
     * @param  int $channelNum 渠道号 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function update (int $id, int $channelNum = 0, string $name = '', string $brand = '') {
        return self::getClass()->update([
            "id" => $id,
            "channelNum" => $channelNum,
            "name" => $name,
            "brand" => $brand,
        ]);
    }

    /**
     * 渠道号列表
     *
     * @support  string $name 渠道名称 
     * @support  string $brand 品牌(himo,mantu,himo_kids,himo_lens,himo_business) 
     * @support  int $channelNum 渠道号 
     * @support  int $page 页码 [Original type uint] 
     * @support  int $pageSize 每页条数 [Original type uint] 
     * @throws  \Exception
     * @return  array
     */
    public static function list () {
        return self::getClass()->list();
    }

    /**
     * 删除渠道
     *
     * @param  int $id 渠道id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function delete (int $id) {
        return self::getClass()->delete([
            "id" => $id,
        ]);
    }

    /**
     * 获取渠道日志
     *
     * @support  int $id 渠道id [ require true ]
     * @support  bool $fromSubscribe 来自新注册用户 
     * @throws  \Exception
     * @return  array
     */
    public static function logs () {
        return self::getClass()->logs();
    }

    /**
     * 获取渠道日志计数
     *
     * @param  array $ids 渠道ids [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function logsCount (array $ids) {
        return self::getClass()->logsCount([
            "ids" => $ids,
        ]);
    }

    /**
     * 目前开放给外部
     *
     * @param  int $id 渠道id [ require true ]
     * @throws  \Exception
     * @return  string
     */
    public static function channelQrcode (int $id) {
        return self::getClass()->channelQrcode([
            "id" => $id,
        ]);
    }

    /**
     * 获取关注/非关注用户列表
     *
     * @support  int $channelId 渠道id 
     * @support  string $openId oepnid 
     * @support  string $brand 品牌 
     * @support  string $start 起始时间,Y-m-d H:i:s [ require true ]
     * @support  string $end 结束时间Y-m-d H:i:s [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getSubscribeUserList () {
        return self::getClass()->getSubscribeUserList();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('UserAuth', 'Channel');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('UserAuth', 'Channel');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}