<?php
namespace Mainto\Bridge\Invokes\UserAuth;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method newThirdWechatAuthByParams(array $params)
 * @method getWechatInfoByCodeByParams(array $params)
 */
class ThirdWechat {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 新建第三方证书
     *
     * @param  string $startUsageTime 开始使用时间 [ require true ]
     * @param  string $stopUsageTime 结束使用时间 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function newThirdWechatAuth (string $startUsageTime = NULL, string $stopUsageTime = NULL) {
        return self::getClass()->newThirdWechatAuth([
            "startUsageTime" => $startUsageTime,
            "stopUsageTime" => $stopUsageTime,
        ]);
    }

    /**
     * 根据code获取 auth.haimati.cn 微信登录信息
     *
     * @param  string $key 证书授权码 [ require true ]
     * @param  string $code 授权码 [ require true ]
     * @param  bool $isAdvance 是否为高级授权, 对应微信 snsapi_userinfo [ require true ]
     * @throws  \Exception
     * @return  string
     */
    public static function getWechatInfoByCode (string $key, string $code, bool $isAdvance = false) {
        return self::getClass()->getWechatInfoByCode([
            "key" => $key,
            "code" => $code,
            "isAdvance" => $isAdvance,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('UserAuth', 'ThirdWechat');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('UserAuth', 'ThirdWechat');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}