<?php
namespace Mainto\Bridge\Invokes\UserAuth;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getJssdkByParams(array $params)
 * @method getApiTicketByParams(array $params)
 * @method getAccessTokenByParams(array $params)
 * @method getWxCardExtFieldByParams(array $params)
 * @method consumeWxCardCodeByParams(array $params)
 * @method decryptWxCardCodeByParams(array $params)
 * @method sendTemplateMsgByParams(array $params)
 * @method sendTemplateMsgByWxAppByParams(array $params)
 * @method sendKfMsgByParams(array $params)
 * @method sendKfMsgAllTypeByParams(array $params)
 * @method sendAllTemplateByParams(array $params)
 * @method checkWxCardCodeByParams(array $params)
 * @method getMaterialListByParams(array $params)
 * @method serveGetByParams(array $params)
 * @method servePostByParams(array $params)
 * @method testByParams(array $params)
 */
class Wx {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 微信获取jssdk配置
     *
     * @param  string $scene 项目 [ require true ]
     * @param  string $url 页面当前地址 [ require true ]
     * @param  bool $debug 调试模式 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getJssdk (string $scene, string $url, bool $debug = false) {
        return self::getClass()->getJssdk([
            "scene" => $scene,
            "url" => $url,
            "debug" => $debug,
        ]);
    }

    /**
     * 获取api ticket
     *
     * @param  string $scene 项目 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getApiTicket (string $scene) {
        return self::getClass()->getApiTicket([
            "scene" => $scene,
        ]);
    }

    /**
     * 获取accessToken
     *
     * @param  string $scene 项目 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getAccessToken (string $scene) {
        return self::getClass()->getAccessToken([
            "scene" => $scene,
        ]);
    }

    /**
     * 生成微信卡券CardExt
     *
     * @param  string $scene 应用 [ require true ]
     * @param  string $code 卡券code [ require true ]
     * @param  string $openid openid [ require true ]
     * @param  string $card_id 卡券id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getWxCardExtField (string $scene, string $code = '', string $openid = '', string $card_id = '') {
        return self::getClass()->getWxCardExtField([
            "scene" => $scene,
            "code" => $code,
            "openid" => $openid,
            "card_id" => $card_id,
        ]);
    }

    /**
     * 核销微信卡券code
     *
     * @param  string $scene 应用 [ require true ]
     * @param  string $code code [ require true ]
     * @param  string $cardId card_id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function consumeWxCardCode (string $scene, string $code, string $cardId) {
        return self::getClass()->consumeWxCardCode([
            "scene" => $scene,
            "code" => $code,
            "cardId" => $cardId,
        ]);
    }

    /**
     * 解密微信卡券Code
     *
     * @param  string $scene code [ require true ]
     * @param  string $encryptCode 加密的数据 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function decryptWxCardCode (string $scene, string $encryptCode) {
        return self::getClass()->decryptWxCardCode([
            "scene" => $scene,
            "encryptCode" => $encryptCode,
        ]);
    }

    /**
     * 发送模板消息
     *
     * @param  string $template_id 模板id [ require true ]
     * @param  array $data 参数数据 [ require true ]
     * @param  int $type id类型 1用户id 2用户手机号 3openid [ require true ]
     * @param  string $id 可以是手机号 openid 用户id,根据type识别 [ require true ]
     * @param  string $app_name 应用名称 [ require true ]
     * @param  string $url 点击跳转的链接 [ require true ]
     * @param  array $miniProgram 跳转小程序 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function sendTemplateMsg (int $type, string $id, string $app_name, string $template_id, array $data = [], string $url = '', array $miniProgram = []) {
        return self::getClass()->sendTemplateMsg([
            "type" => $type,
            "id" => $id,
            "app_name" => $app_name,
            "template_id" => $template_id,
            "data" => $data,
            "url" => $url,
            "miniProgram" => $miniProgram,
        ]);
    }

    /**
     * 发送微信小程序模板消息
     *
     * @param  string $template_id 模板id [ require true ]
     * @param  string $form_id 表单ID|支付ID [ require true ]
     * @param  array $data 参数数据 [ require true ]
     * @param  string $id 可以是手机号 openid 用户id,根据type识别 [ require true ]
     * @param  string $app_name 应用名称 [ require true ]
     * @param  string $page 小程序跳转页 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function sendTemplateMsgByWxApp (string $id, string $app_name, string $template_id, string $form_id, array $data = [], string $page = '') {
        return self::getClass()->sendTemplateMsgByWxApp([
            "id" => $id,
            "app_name" => $app_name,
            "template_id" => $template_id,
            "form_id" => $form_id,
            "data" => $data,
            "page" => $page,
        ]);
    }

    /**
     * 发送微信客服消息 （仅支持字符串）
     *
     * @param  int $type id类型 1用户id 2用户手机号 3openid [ require true ]
     * @param  string $id 可以是手机号 openid 用户id,根据type识别 [ require true ]
     * @param  string $app_name 应用名称 [ require true ]
     * @param  string $content 发送消息 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function sendKfMsg (int $type, string $id, string $app_name, string $content) {
        return self::getClass()->sendKfMsg([
            "type" => $type,
            "id" => $id,
            "app_name" => $app_name,
            "content" => $content,
        ]);
    }

    /**
     * 发送微信客服消息 (支持所有格式)
     *
     * @param  int $type id类型 1用户id 2用户手机号 3openid [ require true ]
     * @param  string $id 可以是手机号 openid 用户id,根据type识别 [ require true ]
     * @param  string $app_name 应用名称 [ require true ]
     * @param  array $content 发送消息 [ require true ]
     * @param  int $msgType 消息类型 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function sendKfMsgAllType (int $type, string $id, string $app_name, array $content, int $msgType = 1) {
        return self::getClass()->sendKfMsgAllType([
            "type" => $type,
            "id" => $id,
            "app_name" => $app_name,
            "content" => $content,
            "msgType" => $msgType,
        ]);
    }

    /**
     * sendAllTemplate
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function sendAllTemplate () {
        return self::getClass()->sendAllTemplate();
    }

    /**
     * 获取微信卡券Code状态信息
     *
     * @param  string $scene 应用 [ require true ]
     * @param  string $code code [ require true ]
     * @param  string $cardId card_id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function checkWxCardCode (string $scene, string $code, string $cardId) {
        return self::getClass()->checkWxCardCode([
            "scene" => $scene,
            "code" => $code,
            "cardId" => $cardId,
        ]);
    }

    /**
     * 获取永久素材列表
     *
     * @param  string $app_name 应用名称 [ require true ]
     * @param  string $type 素材类型(image,video,voice,news) [ require true ]
     * @param  int $offset 从该偏移位置开始返回 [ require true ]
     * @param  int $count 返回素材的数量(1-20) [ require true ]
     * @throws  \Exception
     * @return  string
     */
    public static function getMaterialList (string $app_name, string $type, int $offset = 0, int $count = 20) {
        return self::getClass()->getMaterialList([
            "app_name" => $app_name,
            "type" => $type,
            "offset" => $offset,
            "count" => $count,
        ]);
    }

    /**
     * serveGet
     *
     * @throws  \Exception
     * @return  string
     */
    public static function serveGet () {
        return self::getClass()->serveGet();
    }

    /**
     * servePost
     *
     * @throws  \Exception
     * @return  string
     */
    public static function servePost () {
        return self::getClass()->servePost();
    }

    /**
     * 测试
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function test () {
        return self::getClass()->test();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('UserAuth', 'Wx');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('UserAuth', 'Wx');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}