<?php
namespace Mainto\Bridge\Invokes\UploadExternalOrder\Douyin;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method douyinOrderQuerySettingByParams(array $params)
 * @method douyinOrderSettingByParams(array|\Mainto\Bridge\Structs\UploadExternalOrder\Douyin\Cmd\DouyinOrderSettingCmd $params)
 */
class DouyinOrderV2 {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 抖音查询回调地址
     *
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\UploadExternalOrder\Douyin\DTO\DouyinCallbackUrlDTO
     */
    public static function douyinOrderQuerySetting () {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->douyinOrderQuerySetting(),
            "\Mainto\Bridge\Structs\UploadExternalOrder\Douyin\DTO\DouyinCallbackUrlDTO"
        );
    }

    /**
     * 抖音设置回调地址
     *
     * @var  \Mainto\Bridge\Structs\UploadExternalOrder\Douyin\Cmd\DouyinOrderSettingCmd $douyinOrderSettingCmd
     * @throws  \Exception
     * @return  bool
     */
    public static function douyinOrderSetting (\Mainto\Bridge\Structs\UploadExternalOrder\Douyin\Cmd\DouyinOrderSettingCmd $douyinOrderSettingCmd) {
        return self::getClass()->douyinOrderSetting($douyinOrderSettingCmd);
    }


    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('UploadExternalOrder', 'Douyin\DouyinOrderV2');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('UploadExternalOrder', 'Douyin\DouyinOrderV2');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}