<?php
namespace Mainto\Bridge\Invokes\UploadExternalOrder\Douyin;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method douyinCreateOrderByParams(array|\Mainto\Bridge\Structs\UploadExternalOrder\Douyin\Cmd\DouyinOrderPushCmd $params)
 * @method douyinPaidOrderByParams(array|\Mainto\Bridge\Structs\UploadExternalOrder\Douyin\Cmd\DouyinOrderPushCmd $params)
 * @method douyinCancelOrderByParams(array|\Mainto\Bridge\Structs\UploadExternalOrder\Douyin\Cmd\DouyinOrderPushCmd $params)
 * @method douyinUsedOrderByParams(array|\Mainto\Bridge\Structs\UploadExternalOrder\Douyin\Cmd\DouyinOrderPushCmd $params)
 * @method douyinRefundOrderByParams(array|\Mainto\Bridge\Structs\UploadExternalOrder\Douyin\Cmd\DouyinOrderPushCmd $params)
 * @method douyinRefundOrderSuccessByParams(array|\Mainto\Bridge\Structs\UploadExternalOrder\Douyin\Cmd\DouyinOrderPushCmd $params)
 */
class DouyinOrder {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 同步抖音订单.创建订单
     *
     * @var  \Mainto\Bridge\Structs\UploadExternalOrder\Douyin\Cmd\DouyinOrderPushCmd $douyinOrderPushCmd
     * @throws  \Exception
     * @return  bool
     */
    public static function douyinCreateOrder (\Mainto\Bridge\Structs\UploadExternalOrder\Douyin\Cmd\DouyinOrderPushCmd $douyinOrderPushCmd) {
        return self::getClass()->douyinCreateOrder($douyinOrderPushCmd);
    }


    /**
     * 同步抖音订单.订单支付
     *
     * @var  \Mainto\Bridge\Structs\UploadExternalOrder\Douyin\Cmd\DouyinOrderPushCmd $douyinOrderPushCmd
     * @throws  \Exception
     * @return  bool
     */
    public static function douyinPaidOrder (\Mainto\Bridge\Structs\UploadExternalOrder\Douyin\Cmd\DouyinOrderPushCmd $douyinOrderPushCmd) {
        return self::getClass()->douyinPaidOrder($douyinOrderPushCmd);
    }


    /**
     * 同步抖音订单.取消订单
     *
     * @var  \Mainto\Bridge\Structs\UploadExternalOrder\Douyin\Cmd\DouyinOrderPushCmd $douyinOrderPushCmd
     * @throws  \Exception
     * @return  bool
     */
    public static function douyinCancelOrder (\Mainto\Bridge\Structs\UploadExternalOrder\Douyin\Cmd\DouyinOrderPushCmd $douyinOrderPushCmd) {
        return self::getClass()->douyinCancelOrder($douyinOrderPushCmd);
    }


    /**
     * 同步抖音订单.订单已使用
     *
     * @var  \Mainto\Bridge\Structs\UploadExternalOrder\Douyin\Cmd\DouyinOrderPushCmd $douyinOrderPushCmd
     * @throws  \Exception
     * @return  bool
     */
    public static function douyinUsedOrder (\Mainto\Bridge\Structs\UploadExternalOrder\Douyin\Cmd\DouyinOrderPushCmd $douyinOrderPushCmd) {
        return self::getClass()->douyinUsedOrder($douyinOrderPushCmd);
    }


    /**
     * 同步抖音订单.创建退款
     *
     * @var  \Mainto\Bridge\Structs\UploadExternalOrder\Douyin\Cmd\DouyinOrderPushCmd $douyinOrderPushCmd
     * @throws  \Exception
     * @return  bool
     */
    public static function douyinRefundOrder (\Mainto\Bridge\Structs\UploadExternalOrder\Douyin\Cmd\DouyinOrderPushCmd $douyinOrderPushCmd) {
        return self::getClass()->douyinRefundOrder($douyinOrderPushCmd);
    }


    /**
     * 同步抖音订单.退款成功
     *
     * @var  \Mainto\Bridge\Structs\UploadExternalOrder\Douyin\Cmd\DouyinOrderPushCmd $douyinOrderPushCmd
     * @throws  \Exception
     * @return  bool
     */
    public static function douyinRefundOrderSuccess (\Mainto\Bridge\Structs\UploadExternalOrder\Douyin\Cmd\DouyinOrderPushCmd $douyinOrderPushCmd) {
        return self::getClass()->douyinRefundOrderSuccess($douyinOrderPushCmd);
    }


    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('UploadExternalOrder', 'Douyin\DouyinOrder');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('UploadExternalOrder', 'Douyin\DouyinOrder');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}