<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2024-04-26 10:09:57
 */
namespace Mainto\Bridge\Invokes\TrainingProject\User;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class ExaminationRecord
 * @method getExaminationRecordByParams(array $params) 获取练习考核记录详情
 * @method getExaminationRecordsByParams(array $params) 获取练习考核记录列表
 * @method beginExamByParams(array $params) 开始练习/考核
 * @method refreshByParams(array $params) 刷新题目
 * @method submitByParams(array $params) 提交练习/考核数据
 * @method exitExamByParams(array $params) 退出练习/考核
 * @method getUpyunSignByParams(array $params) 获取又拍云签名
 */
class ExaminationRecord {
    private static string $serviceName = "TrainingProject";

    private static string $className = "User\\ExaminationRecord";

    /**
     * 获取练习考核记录详情
     * @return  mixed
    */
    public static function getExaminationRecord (int $recordId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getExaminationRecord(["recordId" => $recordId]);
    }
    /**
     * 获取练习考核记录列表
     * @return  mixed
    */
    public static function getExaminationRecords (int $taskId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getExaminationRecords(["taskId" => $taskId]);
    }
    /**
     * 开始练习/考核
     * @return  mixed
    */
    public static function beginExam (int $taskId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->beginExam(["taskId" => $taskId]);
    }
    /**
     * 刷新题目
     * @return  mixed
    */
    public static function refresh (int $recordId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->refresh(["recordId" => $recordId]);
    }
    /**
     * 提交练习/考核数据
     * @return  mixed
    */
    public static function submit (int $recordId, array $submitItem) {
        return RpcClass::getClass(self::$serviceName, self::$className)->submit(["recordId" => $recordId, "submitItem" => $submitItem]);
    }
    /**
     * 退出练习/考核
     * @return  mixed
    */
    public static function exitExam (int $recordId, array $submitItem) {
        return RpcClass::getClass(self::$serviceName, self::$className)->exitExam(["recordId" => $recordId, "submitItem" => $submitItem]);
    }
    /**
     * 获取又拍云签名
     * @return  mixed
    */
    public static function getUpyunSign (string $upyunKey) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getUpyunSign(["upyunKey" => $upyunKey]);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}