<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2024-04-26 10:09:57
 */
namespace Mainto\Bridge\Invokes\TrainingProject\Manage;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class ExaminationRecord
 * @method getPracticeListByParams(array $params) 分页获取练习记录列表.修片
 * @method getAssessmentListByParams(array $params) 分页获取考核记录列表.修片
 * @method getPracticeKnowledgeListByParams(array $params) 分页获取练习记录列表.知识问答
 * @method getAssessmentKnowledgeListByParams(array $params) 分页获取考核记录列表.知识问答
 * @method getExaminationRecordByParams(array $params) 获取练习考核记录详情
 * @method passByParams(array $params) 评分通过
 * @method rejectByParams(array $params) 评分退回
 * @method waitAnswerNotifyByParams(array $params) 提醒答题通知
 * @method sendWaitAnswerNotifyBatchByParams(array $params) 提醒答题通知.一键提醒批量
 */
class ExaminationRecord {
    private static string $serviceName = "TrainingProject";

    private static string $className = "Manage\\ExaminationRecord";

    /**
     * 分页获取练习记录列表.修片
     * @return  mixed
    */
    public static function getPracticeList (int $taskId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getPracticeList(["taskId" => $taskId]);
    }
    /**
     * 分页获取考核记录列表.修片
     * @return  mixed
    */
    public static function getAssessmentList (int $taskId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getAssessmentList(["taskId" => $taskId]);
    }
    /**
     * 分页获取练习记录列表.知识问答
     * @return  mixed
    */
    public static function getPracticeKnowledgeList (int $taskId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getPracticeKnowledgeList(["taskId" => $taskId]);
    }
    /**
     * 分页获取考核记录列表.知识问答
     * @return  mixed
    */
    public static function getAssessmentKnowledgeList (int $taskId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getAssessmentKnowledgeList(["taskId" => $taskId]);
    }
    /**
     * 获取练习考核记录详情
     * @return  mixed
    */
    public static function getExaminationRecord (int $recordId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getExaminationRecord(["recordId" => $recordId]);
    }
    /**
     * 评分通过
     * @return  mixed
    */
    public static function pass (int $recordId, array $reviewItem) {
        return RpcClass::getClass(self::$serviceName, self::$className)->pass(["recordId" => $recordId, "reviewItem" => $reviewItem]);
    }
    /**
     * 评分退回
     * @return  mixed
    */
    public static function reject (int $recordId, array $reviewItem) {
        return RpcClass::getClass(self::$serviceName, self::$className)->reject(["recordId" => $recordId, "reviewItem" => $reviewItem]);
    }
    /**
     * 提醒答题通知
     * @return  mixed
    */
    public static function waitAnswerNotify (int $staffId, string $contentType) {
        return RpcClass::getClass(self::$serviceName, self::$className)->waitAnswerNotify(["staffId" => $staffId, "contentType" => $contentType]);
    }
    /**
     * 提醒答题通知.一键提醒批量
     * @return  mixed
    */
    public static function sendWaitAnswerNotifyBatch (int $taskId, array $departmentIds) {
        return RpcClass::getClass(self::$serviceName, self::$className)->sendWaitAnswerNotifyBatch(["taskId" => $taskId, "departmentIds" => $departmentIds]);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}