<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2024-04-26 10:09:57
 */
namespace Mainto\Bridge\Invokes\TrainingProject\Manage;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Comment
 * @method deleteByParams(array $params) 删除留言/回复
 * @method getCommentListByParams(array $params) 留言列表
 * @method getAllReplyByParams(array $params) 回复列表
 * @method topByParams(array $params) 置顶
 * @method unTopByParams(array $params) 取消置顶
 * @method rewardCreditByParams(array $params) 打赏积分
 * @method replyByParams(array $params) 回复留言
 * @method createByParams(array $params) 新增导出任务
 * @method listByParams(array $params) 获取导出任务列表
 * @method deleteTaskByParams(array $params) 删除导出任务
 */
class Comment {
    private static string $serviceName = "TrainingProject";

    private static string $className = "Manage\\Comment";

    /**
     * 删除留言/回复
     * @return  mixed
    */
    public static function delete (int $id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->delete(["id" => $id]);
    }
    /**
     * 留言列表
     * @return  mixed
    */
    public static function getCommentList (array $departmentIds) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getCommentList(["departmentIds" => $departmentIds]);
    }
    /**
     * 回复列表
     * @return  mixed
    */
    public static function getAllReply (int $topCommentId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getAllReply(["topCommentId" => $topCommentId]);
    }
    /**
     * 置顶
     * @return  mixed
    */
    public static function top (int $commentId, int $relationId, string $type) {
        return RpcClass::getClass(self::$serviceName, self::$className)->top(["commentId" => $commentId, "relationId" => $relationId, "type" => $type]);
    }
    /**
     * 取消置顶
     * @return  mixed
    */
    public static function unTop (int $id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->unTop(["id" => $id]);
    }
    /**
     * 打赏积分
     * @return  mixed
    */
    public static function rewardCredit (int $toStaffId, int $points, int $commentId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->rewardCredit(["toStaffId" => $toStaffId, "points" => $points, "commentId" => $commentId]);
    }
    /**
     * 回复留言
     * @return  mixed
    */
    public static function reply (int $relationId, string $type, int $topCommentId, int $parentId, int $toStaffId, string $comment) {
        return RpcClass::getClass(self::$serviceName, self::$className)->reply(["relationId" => $relationId, "type" => $type, "topCommentId" => $topCommentId, "parentId" => $parentId, "toStaffId" => $toStaffId, "comment" => $comment]);
    }
    /**
     * 新增导出任务
     * @return  mixed
    */
    public static function create () {
        return RpcClass::getClass(self::$serviceName, self::$className)->create([]);
    }
    /**
     * 获取导出任务列表
     * @return  mixed
    */
    public static function list () {
        return RpcClass::getClass(self::$serviceName, self::$className)->list([]);
    }
    /**
     * 删除导出任务
     * @return  mixed
    */
    public static function deleteTask () {
        return RpcClass::getClass(self::$serviceName, self::$className)->deleteTask([]);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}