<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2024-04-26 11:33:11
 */
namespace Mainto\Bridge\Invokes\TrainingProject\User;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Task
 * @method getPracticeTaskListByParams(array $params) 练习列表
 * @method getAssessmentTaskListByParams(array $params) 考核列表
 * @method getTaskByParams(array $params) 详情
 * @method getTaskWithExaminationNumByParams(array $params) 任务详情（包含题目数量）
 * @method getTaskKnowledgeListByParams(array $params) 任务列表.星系研修所
 */
class Task {
    private static string $serviceName = "TrainingProject";

    private static string $className = "User\\Task";

    /**
     * 练习列表
     * @return  mixed
    */
    public static function getPracticeTaskList () {
        return RpcClass::getClass(self::$serviceName, self::$className)->getPracticeTaskList([]);
    }
    /**
     * 考核列表
     * @return  mixed
    */
    public static function getAssessmentTaskList () {
        return RpcClass::getClass(self::$serviceName, self::$className)->getAssessmentTaskList([]);
    }
    /**
     * 详情
     * @return  mixed
    */
    public static function getTask (int $taskId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getTask(["taskId" => $taskId]);
    }
    /**
     * 任务详情（包含题目数量）
     * @return  mixed
    */
    public static function getTaskWithExaminationNum (int $taskId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getTaskWithExaminationNum(["taskId" => $taskId]);
    }
    /**
     * 任务列表.星系研修所
     * @return  mixed
    */
    public static function getTaskKnowledgeList (int $courseId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getTaskKnowledgeList(["courseId" => $courseId]);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}