<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2024-04-26 11:33:11
 */
namespace Mainto\Bridge\Invokes\TrainingProject\Manage\Staff;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class StaffProductCat
 * @method getStaffManageListByParams(array $params) 技术通关管理列表查询
 * @method getProductCatAllByParams(array $params) 通关品类.产品树
 * @method getProductListByParams(array $params) 通关品类.产品列表
 * @method syncProductCatByParams(array $params) 通关品类.产品保存
 * @method fastSyncProductCatByParams(array $params) 通关品类.一键配置
 * @method onProductCatEmptyByParams(array $params) onProductCatEmpty
 * @method getProductCatByParams(array $params) 通关品类.产品列表
 * @method onStaffPluralismConfirmByParams(array $params) 兼岗事件处理
 * @method exportPermissionStoresByParams(array $params) 技术通关管辖门店导出
 * @method getDepartmentStaffsByParams(array $params) 获取门店下伙伴
 */
class StaffProductCat {
    private static string $serviceName = "TrainingProject";

    private static string $className = "Manage\\Staff\\StaffProductCat";

    /**
     * 技术通关管理列表查询
     * @return  array
    */
    public static function getStaffManageList () {
        return RpcClass::getClass(self::$serviceName, self::$className)->getStaffManageList([]);
    }
    /**
     * 通关品类.产品树
     * @return  array
    */
    public static function getProductCatAll () {
        return RpcClass::getClass(self::$serviceName, self::$className)->getProductCatAll();
    }
    /**
     * 通关品类.产品列表
     * @return  array
    */
    public static function getProductList () {
        return RpcClass::getClass(self::$serviceName, self::$className)->getProductList();
    }
    /**
     * 通关品类.产品保存
     * @return  mixed
    */
    public static function syncProductCat (array $staffIds) {
        return RpcClass::getClass(self::$serviceName, self::$className)->syncProductCat(["staffIds" => $staffIds]);
    }
    /**
     * 通关品类.一键配置
     * @return  mixed
    */
    public static function fastSyncProductCat (array $staffIds) {
        return RpcClass::getClass(self::$serviceName, self::$className)->fastSyncProductCat(["staffIds" => $staffIds]);
    }
    /**
     * onProductCatEmpty
     * @return  mixed
    */
    public static function onProductCatEmpty (int $staff_id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->onProductCatEmpty(["staff_id" => $staff_id]);
    }
    /**
     * 通关品类.产品列表
     * @return  mixed
    */
    public static function getProductCat (int $staffId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getProductCat(["staffId" => $staffId]);
    }
    /**
     * 兼岗事件处理
     * @return  void
    */
    public static function onStaffPluralismConfirm (int $staff_id, int $job_id, int $pluralism_store_id) {
         RpcClass::getClass(self::$serviceName, self::$className)->onStaffPluralismConfirm(["staff_id" => $staff_id, "job_id" => $job_id, "pluralism_store_id" => $pluralism_store_id]);
    }
    /**
     * 技术通关管辖门店导出
     * @return  array
    */
    public static function exportPermissionStores () {
        return RpcClass::getClass(self::$serviceName, self::$className)->exportPermissionStores();
    }
    /**
     * 获取门店下伙伴
     * @return  array
    */
    public static function getDepartmentStaffs () {
        return RpcClass::getClass(self::$serviceName, self::$className)->getDepartmentStaffs([]);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}