<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2024-04-25 10:37:56
 */
namespace Mainto\Bridge\Invokes\TrainingProject\User;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Category
 * @method getAllListByParams(array $params) 获取所有匹配的分类列表（不分页）
 * @method getListWithCourseNumByParams(array $params) 获取分类及分类下的课程数
 * @method getCategoryIdsAndCourseIdsByParams(array $params) 获取所有有课程的分类id及所有课程id
 * @method getCategoriesByTypeByParams(array $params) 获取分类列表区分用户（不分页，课程，案例）
 * @method getCategoriesByTypeWithCompulsoryByParams(array $params) 获取所有课程分类数据区分用户（必修，选修）
 */
class Category {
    private static string $serviceName = "TrainingProject";

    private static string $className = "User\\Category";

    /**
     * 获取所有匹配的分类列表（不分页）
     * @return  mixed
    */
    public static function getAllList () {
        return RpcClass::getClass(self::$serviceName, self::$className)->getAllList([]);
    }
    /**
     * 获取分类及分类下的课程数
     * @return  mixed
    */
    public static function getListWithCourseNum (string $categoryType) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getListWithCourseNum(["categoryType" => $categoryType]);
    }
    /**
     * 获取所有有课程的分类id及所有课程id
     * @return  mixed
    */
    public static function getCategoryIdsAndCourseIds () {
        return RpcClass::getClass(self::$serviceName, self::$className)->getCategoryIdsAndCourseIds();
    }
    /**
     * 获取分类列表区分用户（不分页，课程，案例）
     * @return  mixed
    */
    public static function getCategoriesByType () {
        return RpcClass::getClass(self::$serviceName, self::$className)->getCategoriesByType([]);
    }
    /**
     * 获取所有课程分类数据区分用户（必修，选修）
     * @return  mixed
    */
    public static function getCategoriesByTypeWithCompulsory () {
        return RpcClass::getClass(self::$serviceName, self::$className)->getCategoriesByTypeWithCompulsory([]);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}