<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2024-04-25 10:37:56
 */
namespace Mainto\Bridge\Invokes\TrainingProject\Manage;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Task
 * @method checkTaskNameActiveByParams(array $params) 检测任务名称可用
 * @method addTaskByParams(array $params) 创建任务
 * @method editTaskByParams(array $params) 修改任务
 * @method deleteTaskByParams(array $params) 删除任务
 * @method getTaskListByParams(array $params) 列表.分页
 * @method getTasksByParams(array $params) 列表.全部
 * @method getTaskByParams(array $params) 详情
 * @method getUpyunSignByParams(array $params) 获取又拍云签名
 */
class Task {
    private static string $serviceName = "TrainingProject";

    private static string $className = "Manage\\Task";

    /**
     * 检测任务名称可用
     * @return  mixed
    */
    public static function checkTaskNameActive (string $name) {
        return RpcClass::getClass(self::$serviceName, self::$className)->checkTaskNameActive(["name" => $name]);
    }
    /**
     * 创建任务
     * @return  mixed
    */
    public static function addTask (string $name, string $type, string $contentType, string $demand, array $questionItem) {
        return RpcClass::getClass(self::$serviceName, self::$className)->addTask(["name" => $name, "type" => $type, "contentType" => $contentType, "demand" => $demand, "questionItem" => $questionItem]);
    }
    /**
     * 修改任务
     * @return  mixed
    */
    public static function editTask (int $taskId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->editTask(["taskId" => $taskId]);
    }
    /**
     * 删除任务
     * @return  mixed
    */
    public static function deleteTask (int $taskId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->deleteTask(["taskId" => $taskId]);
    }
    /**
     * 列表.分页
     * @return  mixed
    */
    public static function getTaskList () {
        return RpcClass::getClass(self::$serviceName, self::$className)->getTaskList([]);
    }
    /**
     * 列表.全部
     * @return  mixed
    */
    public static function getTasks (string $type) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getTasks(["type" => $type]);
    }
    /**
     * 详情
     * @return  mixed
    */
    public static function getTask (int $taskId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getTask(["taskId" => $taskId]);
    }
    /**
     * 获取又拍云签名
     * @return  mixed
    */
    public static function getUpyunSign (string $upyunKey) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getUpyunSign(["upyunKey" => $upyunKey]);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}