<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2024-04-25 10:37:56
 */
namespace Mainto\Bridge\Invokes\TrainingProject\Manage;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Case
 * @method getCaseListByParams(array $params) 案例.列表分页
 * @method addCaseByParams(array $params) 案例.新增
 * @method editCaseByParams(array $params) 案例.编辑
 * @method getCaseByIdByParams(array $params) 案例.单个详情
 * @method deleteCaseByParams(array $params) 案例.删除
 * @method onlineCaseByParams(array $params) 案例.上下线
 * @method getCaseListWithReadByParams(array $params) 案例.学习明细.列表分页
 * @method createByParams(array $params) 案例.学习明细.下载.新增导出任务
 * @method listByParams(array $params) 案例.学习明细.下载.获取列表分页
 * @method deleteByParams(array $params) 案例.学习明细.下载.删除记录
 */
class Case {
    private static string $serviceName = "TrainingProject";

    private static string $className = "Manage\\Case";

    /**
     * 案例.列表分页
     * @return  mixed
    */
    public static function getCaseList () {
        return RpcClass::getClass(self::$serviceName, self::$className)->getCaseList([]);
    }
    /**
     * 案例.新增
     * @return  mixed
    */
    public static function addCase () {
        return RpcClass::getClass(self::$serviceName, self::$className)->addCase([]);
    }
    /**
     * 案例.编辑
     * @return  mixed
    */
    public static function editCase (int $id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->editCase(["id" => $id]);
    }
    /**
     * 案例.单个详情
     * @return  mixed
    */
    public static function getCaseById (int $id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getCaseById(["id" => $id]);
    }
    /**
     * 案例.删除
     * @return  mixed
    */
    public static function deleteCase (int $id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->deleteCase(["id" => $id]);
    }
    /**
     * 案例.上下线
     * @return  mixed
    */
    public static function onlineCase (int $id, string $status) {
        return RpcClass::getClass(self::$serviceName, self::$className)->onlineCase(["id" => $id, "status" => $status]);
    }
    /**
     * 案例.学习明细.列表分页
     * @return  mixed
    */
    public static function getCaseListWithRead () {
        return RpcClass::getClass(self::$serviceName, self::$className)->getCaseListWithRead([]);
    }
    /**
     * 案例.学习明细.下载.新增导出任务
     * @return  mixed
    */
    public static function create () {
        return RpcClass::getClass(self::$serviceName, self::$className)->create([]);
    }
    /**
     * 案例.学习明细.下载.获取列表分页
     * @return  mixed
    */
    public static function list () {
        return RpcClass::getClass(self::$serviceName, self::$className)->list([]);
    }
    /**
     * 案例.学习明细.下载.删除记录
     * @return  mixed
    */
    public static function delete () {
        return RpcClass::getClass(self::$serviceName, self::$className)->delete([]);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}