<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2024-04-25 10:41:56
 */
namespace Mainto\Bridge\Invokes\TrainingProject\User;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Course
 * @method getCourseCompulsoryListByParams(array $params) 课程（必修，选修，最新）.列表
 * @method getCourseListWithStatusByParams(array $params) 课程（进行中，待学习）.列表
 * @method getNextCourseByCourseIdByParams(array $params) 课程.下一门课程
 * @method getCourseByIdByParams(array $params) 课程.单个详情
 * @method getCourseNamesByCourseIdsByParams(array $params) 课程.通过课程ids获得课程名
 * @method submitAnswerByParams(array $params) 提交课程小节题答案
 * @method remarkCourseDoneByParams(array $params) 课程.课程内容已学完
 * @method updateCourseScheduleExtendByParams(array $params) 课程.课程学习时间记录
 * @method getMessageListByParams(array $params) 课程.获取员工提醒
 * @method readByParams(array $params) 课程.设为已读
 * @method onStaffUpdateByParams(array $params) 员工信息变更
 */
class Course {
    private static string $serviceName = "TrainingProject";

    private static string $className = "User\\Course";

    /**
     * 课程（必修，选修，最新）.列表
     * @return  mixed
    */
    public static function getCourseCompulsoryList () {
        return RpcClass::getClass(self::$serviceName, self::$className)->getCourseCompulsoryList([]);
    }
    /**
     * 课程（进行中，待学习）.列表
     * @return  mixed
    */
    public static function getCourseListWithStatus () {
        return RpcClass::getClass(self::$serviceName, self::$className)->getCourseListWithStatus([]);
    }
    /**
     * 课程.下一门课程
     * @return  mixed
    */
    public static function getNextCourseByCourseId (int $courseId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getNextCourseByCourseId(["courseId" => $courseId]);
    }
    /**
     * 课程.单个详情
     * @return  mixed
    */
    public static function getCourseById (int $id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getCourseById(["id" => $id]);
    }
    /**
     * 课程.通过课程ids获得课程名
     * @return  mixed
    */
    public static function getCourseNamesByCourseIds () {
        return RpcClass::getClass(self::$serviceName, self::$className)->getCourseNamesByCourseIds([]);
    }
    /**
     * 提交课程小节题答案
     * @return  mixed
    */
    public static function submitAnswer (int $courseId, int $staffId, int $questionId,  $answerInfo) {
        return RpcClass::getClass(self::$serviceName, self::$className)->submitAnswer(["courseId" => $courseId, "staffId" => $staffId, "questionId" => $questionId, "answerInfo" => $answerInfo]);
    }
    /**
     * 课程.课程内容已学完
     * @return  mixed
    */
    public static function remarkCourseDone (int $id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->remarkCourseDone(["id" => $id]);
    }
    /**
     * 课程.课程学习时间记录
     * @return  mixed
    */
    public static function updateCourseScheduleExtend (int $id, array $extend) {
        return RpcClass::getClass(self::$serviceName, self::$className)->updateCourseScheduleExtend(["id" => $id, "extend" => $extend]);
    }
    /**
     * 课程.获取员工提醒
     * @return  mixed
    */
    public static function getMessageList () {
        return RpcClass::getClass(self::$serviceName, self::$className)->getMessageList();
    }
    /**
     * 课程.设为已读
     * @return  mixed
    */
    public static function read (int $id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->read(["id" => $id]);
    }
    /**
     * 员工信息变更
     * @return  void
    */
    public static function onStaffUpdate () {
         RpcClass::getClass(self::$serviceName, self::$className)->onStaffUpdate();
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}