<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2024-04-25 10:41:56
 */
namespace Mainto\Bridge\Invokes\TrainingProject\User;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Comment
 * @method addByParams(array $params) 添加留言
 * @method deleteByParams(array $params) 删除留言回复
 * @method likeByParams(array $params) 点赞
 * @method cancelLikeByParams(array $params) 取消点赞
 * @method replyByParams(array $params) 添加回复
 * @method getReplyListByParams(array $params) 按分页获取回复列表
 * @method getCommentListByParams(array $params) 按分页获取留言列表
 */
class Comment {
    private static string $serviceName = "TrainingProject";

    private static string $className = "User\\Comment";

    /**
     * 添加留言
     * @return  mixed
    */
    public static function add (int $relationId, string $type, string $comment) {
        return RpcClass::getClass(self::$serviceName, self::$className)->add(["relationId" => $relationId, "type" => $type, "comment" => $comment]);
    }
    /**
     * 删除留言回复
     * @return  mixed
    */
    public static function delete (int $id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->delete(["id" => $id]);
    }
    /**
     * 点赞
     * @return  mixed
    */
    public static function like (int $commentId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->like(["commentId" => $commentId]);
    }
    /**
     * 取消点赞
     * @return  mixed
    */
    public static function cancelLike (int $commentId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->cancelLike(["commentId" => $commentId]);
    }
    /**
     * 添加回复
     * @return  mixed
    */
    public static function reply (int $relationId, string $type, int $topCommentId, int $parentId, int $toStaffId, string $comment) {
        return RpcClass::getClass(self::$serviceName, self::$className)->reply(["relationId" => $relationId, "type" => $type, "topCommentId" => $topCommentId, "parentId" => $parentId, "toStaffId" => $toStaffId, "comment" => $comment]);
    }
    /**
     * 按分页获取回复列表
     * @return  mixed
    */
    public static function getReplyList (int $topCommentId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getReplyList(["topCommentId" => $topCommentId]);
    }
    /**
     * 按分页获取留言列表
     * @return  mixed
    */
    public static function getCommentList (int $relationId, string $type) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getCommentList(["relationId" => $relationId, "type" => $type]);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}