<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2024-04-25 10:41:56
 */
namespace Mainto\Bridge\Invokes\TrainingProject\Manage\RBAC;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Admin
 * @method getAdminListByParams(array $params) 管理员列表
 * @method addAdminByParams(array $params) 管理员新增
 * @method updateAdminByParams(array $params) 管理员更新
 * @method updateServicePermissionStoreByParams(array $params) 更新服务通关的门店管辖范围
 * @method updateProductPermissionStoreByParams(array $params) 更新技术通关的门店管辖范围
 * @method deleteAdminByParams(array $params) 管理员删除
 * @method onStaffDeletedByParams(array $params) onStaffDeleted
 * @method getPermissionsByParams(array $params) 管理员个人拥有的权限
 * @method loginDetailByParams(array $params) 管理员登录个人和权限信息
 * @method storeCreatedByParams(array $params) 新店自动开通城市经理、区域经理的服务通关权限
 */
class Admin {
    private static string $serviceName = "TrainingProject";

    private static string $className = "Manage\\RBAC\\Admin";

    /**
     * 管理员列表
     * @return  array
    */
    public static function getAdminList () {
        return RpcClass::getClass(self::$serviceName, self::$className)->getAdminList([]);
    }
    /**
     * 管理员新增
     * @return  bool
    */
    public static function addAdmin (int $staffId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->addAdmin(["staffId" => $staffId]);
    }
    /**
     * 管理员更新
     * @return  bool
    */
    public static function updateAdmin (int $staffId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->updateAdmin(["staffId" => $staffId]);
    }
    /**
     * 更新服务通关的门店管辖范围
     * @return  bool
    */
    public static function updateServicePermissionStore (int $staffId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->updateServicePermissionStore(["staffId" => $staffId]);
    }
    /**
     * 更新技术通关的门店管辖范围
     * @return  bool
    */
    public static function updateProductPermissionStore (int $staffId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->updateProductPermissionStore(["staffId" => $staffId]);
    }
    /**
     * 管理员删除
     * @return  bool
    */
    public static function deleteAdmin (int $staffId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->deleteAdmin(["staffId" => $staffId]);
    }
    /**
     * onStaffDeleted
     * @return  bool
    */
    public static function onStaffDeleted (int $staff_id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->onStaffDeleted(["staff_id" => $staff_id]);
    }
    /**
     * 管理员个人拥有的权限
     * @return  array
    */
    public static function getPermissions (int $staffId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getPermissions(["staffId" => $staffId]);
    }
    /**
     * 管理员登录个人和权限信息
     * @return  array
    */
    public static function loginDetail () {
        return RpcClass::getClass(self::$serviceName, self::$className)->loginDetail();
    }
    /**
     * 新店自动开通城市经理、区域经理的服务通关权限
     * @return  bool
    */
    public static function storeCreated () {
        return RpcClass::getClass(self::$serviceName, self::$className)->storeCreated();
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}