<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2024-04-25 10:41:56
 */
namespace Mainto\Bridge\Invokes\TrainingProject\Manage;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Course
 * @method checkCourseNameActiveByParams(array $params) 课程.检测课程名称可用
 * @method getCourseListByParams(array $params) 课程.列表分页
 * @method getAllCourseNamesByParams(array $params) 课程.所有.名称
 * @method addCourseByParams(array $params) 课程.新增
 * @method editCourseByParams(array $params) 课程.编辑
 * @method getCourseByIdByParams(array $params) 课程.单个详情
 * @method deleteCourseByParams(array $params) 课程.删除
 * @method onlineCourseByParams(array $params) 课程.上下线
 * @method getGroupIdsByIdByParams(array $params) 课程.获得groupIds
 * @method getStaffStudyListByParams(array $params) 课程.学习明细.个人数据列表分页
 * @method addRemindByParams(array $params) 课程.学习明细.提醒
 * @method getCourseScheduleListByStaffIdAndStudyStatusByParams(array $params) 课程.学习明细.个人详情
 * @method getCourseListByCourseIdsAndStudyTypeAndNameByParams(array $params) 课程.学习明细.课程数据列表分页
 * @method createByParams(array $params) 课程.学习明细.下载.新增导出任务
 * @method listByParams(array $params) 课程.学习明细.下载.获取列表分页
 * @method deleteByParams(array $params) 课程.学习明细.下载.删除记录
 */
class Course {
    private static string $serviceName = "TrainingProject";

    private static string $className = "Manage\\Course";

    /**
     * 课程.检测课程名称可用
     * @return  mixed
    */
    public static function checkCourseNameActive (string $name) {
        return RpcClass::getClass(self::$serviceName, self::$className)->checkCourseNameActive(["name" => $name]);
    }
    /**
     * 课程.列表分页
     * @return  mixed
    */
    public static function getCourseList () {
        return RpcClass::getClass(self::$serviceName, self::$className)->getCourseList([]);
    }
    /**
     * 课程.所有.名称
     * @return  mixed
    */
    public static function getAllCourseNames () {
        return RpcClass::getClass(self::$serviceName, self::$className)->getAllCourseNames([]);
    }
    /**
     * 课程.新增
     * @return  mixed
    */
    public static function addCourse () {
        return RpcClass::getClass(self::$serviceName, self::$className)->addCourse([]);
    }
    /**
     * 课程.编辑
     * @return  mixed
    */
    public static function editCourse (int $id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->editCourse(["id" => $id]);
    }
    /**
     * 课程.单个详情
     * @return  mixed
    */
    public static function getCourseById (int $id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getCourseById(["id" => $id]);
    }
    /**
     * 课程.删除
     * @return  mixed
    */
    public static function deleteCourse (int $id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->deleteCourse(["id" => $id]);
    }
    /**
     * 课程.上下线
     * @return  mixed
    */
    public static function onlineCourse (int $id, string $status) {
        return RpcClass::getClass(self::$serviceName, self::$className)->onlineCourse(["id" => $id, "status" => $status]);
    }
    /**
     * 课程.获得groupIds
     * @return  mixed
    */
    public static function getGroupIdsById (int $id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getGroupIdsById(["id" => $id]);
    }
    /**
     * 课程.学习明细.个人数据列表分页
     * @return  mixed
    */
    public static function getStaffStudyList () {
        return RpcClass::getClass(self::$serviceName, self::$className)->getStaffStudyList([]);
    }
    /**
     * 课程.学习明细.提醒
     * @return  mixed
    */
    public static function addRemind (int $staffId, string $msg) {
        return RpcClass::getClass(self::$serviceName, self::$className)->addRemind(["staffId" => $staffId, "msg" => $msg]);
    }
    /**
     * 课程.学习明细.个人详情
     * @return  mixed
    */
    public static function getCourseScheduleListByStaffIdAndStudyStatus (int $staffId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getCourseScheduleListByStaffIdAndStudyStatus(["staffId" => $staffId]);
    }
    /**
     * 课程.学习明细.课程数据列表分页
     * @return  mixed
    */
    public static function getCourseListByCourseIdsAndStudyTypeAndName () {
        return RpcClass::getClass(self::$serviceName, self::$className)->getCourseListByCourseIdsAndStudyTypeAndName([]);
    }
    /**
     * 课程.学习明细.下载.新增导出任务
     * @return  mixed
    */
    public static function create () {
        return RpcClass::getClass(self::$serviceName, self::$className)->create([]);
    }
    /**
     * 课程.学习明细.下载.获取列表分页
     * @return  mixed
    */
    public static function list () {
        return RpcClass::getClass(self::$serviceName, self::$className)->list([]);
    }
    /**
     * 课程.学习明细.下载.删除记录
     * @return  mixed
    */
    public static function delete () {
        return RpcClass::getClass(self::$serviceName, self::$className)->delete([]);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}