<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2024-04-25 10:23:07
 */
namespace Mainto\Bridge\Invokes\TrainingProject\Manage;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Teacher
 * @method createByParams(array $params) 添加讲师
 * @method updateByParams(array $params) 修改讲师信息
 * @method deleteByParams(array $params) 删除讲师信息
 * @method getDetailByParams(array $params) 讲师详情
 * @method getListByPaginateByParams(array $params) 讲师列表.分页
 * @method getAllListByParams(array $params) 讲师列表.不分页
 */
class Teacher {
    private static string $serviceName = "TrainingProject";

    private static string $className = "Manage\\Teacher";

    /**
     * 添加讲师
     * @return  mixed
    */
    public static function create (string $name, string $avatar) {
        return RpcClass::getClass(self::$serviceName, self::$className)->create(["name" => $name, "avatar" => $avatar]);
    }
    /**
     * 修改讲师信息
     * @return  mixed
    */
    public static function update (int $id, string $name, string $avatar) {
        return RpcClass::getClass(self::$serviceName, self::$className)->update(["id" => $id, "name" => $name, "avatar" => $avatar]);
    }
    /**
     * 删除讲师信息
     * @return  mixed
    */
    public static function delete (int $id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->delete(["id" => $id]);
    }
    /**
     * 讲师详情
     * @return  mixed
    */
    public static function getDetail (int $id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getDetail(["id" => $id]);
    }
    /**
     * 讲师列表.分页
     * @return  mixed
    */
    public static function getListByPaginate () {
        return RpcClass::getClass(self::$serviceName, self::$className)->getListByPaginate([]);
    }
    /**
     * 讲师列表.不分页
     * @return  mixed
    */
    public static function getAllList () {
        return RpcClass::getClass(self::$serviceName, self::$className)->getAllList([]);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}