<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2024-04-25 10:23:07
 */
namespace Mainto\Bridge\Invokes\TrainingProject\Manage\Staff;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class StaffService
 * @method getServiceListByParams(array $params) 服务通关管理列表查询
 * @method syncServicePassByParams(array $params) 服务通关保存
 * @method exportByParams(array $params) 服务通关管理导出
 * @method onStaffCreatedByParams(array $params) 入职添加账号
 * @method onStaffUpdatedByParams(array $params) 修改添加账号
 * @method onStaffRecoverByParams(array $params) 二次入职添加账号
 * @method exportPermissionStoresByParams(array $params) 服务通关管辖门店导出
 */
class StaffService {
    private static string $serviceName = "TrainingProject";

    private static string $className = "Manage\\Staff\\StaffService";

    /**
     * 服务通关管理列表查询
     * @return  array
    */
    public static function getServiceList () {
        return RpcClass::getClass(self::$serviceName, self::$className)->getServiceList([]);
    }
    /**
     * 服务通关保存
     * @return  bool
    */
    public static function syncServicePass (int $staffId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->syncServicePass(["staffId" => $staffId]);
    }
    /**
     * 服务通关管理导出
     * @return  array
    */
    public static function export () {
        return RpcClass::getClass(self::$serviceName, self::$className)->export([]);
    }
    /**
     * 入职添加账号
     * @return  bool
    */
    public static function onStaffCreated (int $staffId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->onStaffCreated(["staffId" => $staffId]);
    }
    /**
     * 修改添加账号
     * @return  bool
    */
    public static function onStaffUpdated (int $staffId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->onStaffUpdated(["staffId" => $staffId]);
    }
    /**
     * 二次入职添加账号
     * @return  bool
    */
    public static function onStaffRecover (int $staffId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->onStaffRecover(["staffId" => $staffId]);
    }
    /**
     * 服务通关管辖门店导出
     * @return  array
    */
    public static function exportPermissionStores () {
        return RpcClass::getClass(self::$serviceName, self::$className)->exportPermissionStores();
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}