<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2024-04-25 10:23:07
 */
namespace Mainto\Bridge\Invokes\TrainingProject\Manage;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class QuestionBank
 * @method checkQuestionBankNameActiveByParams(array $params) 检测题库名称可用
 * @method addQuestionBankByParams(array $params) 创建题库
 * @method editQuestionBankByParams(array $params) 修改题库
 * @method deleteQuestionBankByParams(array $params) 删除题库
 * @method getQuestionBankListByParams(array $params) 列表
 * @method getQuestionBankByParams(array $params) 详情
 * @method getQuestionBanksByIdsByParams(array $params) 根据ids获取数据
 * @method getQuestionBanksByParams(array $params) 获取自动生成题库数据
 */
class QuestionBank {
    private static string $serviceName = "TrainingProject";

    private static string $className = "Manage\\QuestionBank";

    /**
     * 检测题库名称可用
     * @return  mixed
    */
    public static function checkQuestionBankNameActive (string $name) {
        return RpcClass::getClass(self::$serviceName, self::$className)->checkQuestionBankNameActive(["name" => $name]);
    }
    /**
     * 创建题库
     * @return  mixed
    */
    public static function addQuestionBank (string $name, string $type, string $applyIn, int $count, array $questions) {
        return RpcClass::getClass(self::$serviceName, self::$className)->addQuestionBank(["name" => $name, "type" => $type, "applyIn" => $applyIn, "count" => $count, "questions" => $questions]);
    }
    /**
     * 修改题库
     * @return  mixed
    */
    public static function editQuestionBank (int $id, string $applyIn) {
        return RpcClass::getClass(self::$serviceName, self::$className)->editQuestionBank(["id" => $id, "applyIn" => $applyIn]);
    }
    /**
     * 删除题库
     * @return  mixed
    */
    public static function deleteQuestionBank (int $id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->deleteQuestionBank(["id" => $id]);
    }
    /**
     * 列表
     * @return  mixed
    */
    public static function getQuestionBankList () {
        return RpcClass::getClass(self::$serviceName, self::$className)->getQuestionBankList([]);
    }
    /**
     * 详情
     * @return  mixed
    */
    public static function getQuestionBank (int $id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getQuestionBank(["id" => $id]);
    }
    /**
     * 根据ids获取数据
     * @return  mixed
    */
    public static function getQuestionBanksByIds (array $questionBankIds) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getQuestionBanksByIds(["questionBankIds" => $questionBankIds]);
    }
    /**
     * 获取自动生成题库数据
     * @return  mixed
    */
    public static function getQuestionBanks () {
        return RpcClass::getClass(self::$serviceName, self::$className)->getQuestionBanks([]);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}