<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2024-04-25 10:23:07
 */
namespace Mainto\Bridge\Invokes\TrainingProject\Manage;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class CoursePlan
 * @method getCoursePlanListByParams(array $params) 学习计划.分页列表
 * @method addCoursePlanByParams(array $params) 学习计划.新增
 * @method editCoursePlanByParams(array $params) 学习计划.编辑
 * @method deleteCoursePlanByParams(array $params) 学习计划.删除
 * @method getCourseIdsByPlanIdByParams(array $params) 学习计划.获取课程id数组
 * @method getCourseSchedulesInJsonByPlanIdByParams(array $params) 学习计划.获取有结构的课程id数据
 * @method existCoursePlanNameOrGetGroupIdsByParams(array $params) 学习计划.判断学习计划名称
 */
class CoursePlan {
    private static string $serviceName = "TrainingProject";

    private static string $className = "Manage\\CoursePlan";

    /**
     * 学习计划.分页列表
     * @return  mixed
    */
    public static function getCoursePlanList () {
        return RpcClass::getClass(self::$serviceName, self::$className)->getCoursePlanList([]);
    }
    /**
     * 学习计划.新增
     * @return  mixed
    */
    public static function addCoursePlan (array $schedules) {
        return RpcClass::getClass(self::$serviceName, self::$className)->addCoursePlan(["schedules" => $schedules]);
    }
    /**
     * 学习计划.编辑
     * @return  mixed
    */
    public static function editCoursePlan (array $schedules) {
        return RpcClass::getClass(self::$serviceName, self::$className)->editCoursePlan(["schedules" => $schedules]);
    }
    /**
     * 学习计划.删除
     * @return  mixed
    */
    public static function deleteCoursePlan () {
        return RpcClass::getClass(self::$serviceName, self::$className)->deleteCoursePlan([]);
    }
    /**
     * 学习计划.获取课程id数组
     * @return  mixed
    */
    public static function getCourseIdsByPlanId (int $id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getCourseIdsByPlanId(["id" => $id]);
    }
    /**
     * 学习计划.获取有结构的课程id数据
     * @return  mixed
    */
    public static function getCourseSchedulesInJsonByPlanId (int $id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getCourseSchedulesInJsonByPlanId(["id" => $id]);
    }
    /**
     * 学习计划.判断学习计划名称
     * @return  mixed
    */
    public static function existCoursePlanNameOrGetGroupIds (string $name, array $groupIds) {
        return RpcClass::getClass(self::$serviceName, self::$className)->existCoursePlanNameOrGetGroupIds(["name" => $name, "groupIds" => $groupIds]);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}