<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2024-04-25 10:31:44
 */
namespace Mainto\Bridge\Invokes\TrainingProject\User\DingTalk;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Staff
 * @method loginDetailByParams(array $params) 获取用户信息
 * @method dynamicByParams(array $params) 获取学习动态
 * @method exchangeWishValueByParams(array $params) 兑换愿望值
 * @method getChangeLogListByParams(array $params) 获取积分变更事件
 * @method getCreditTypeByParams(array $params) 获取积分类型
 * @method getTopByParams(array $params) 获得排行信息
 */
class Staff {
    private static string $serviceName = "TrainingProject";

    private static string $className = "User\\DingTalk\\Staff";

    /**
     * 获取用户信息
     * @return  mixed
    */
    public static function loginDetail () {
        return RpcClass::getClass(self::$serviceName, self::$className)->loginDetail();
    }
    /**
     * 获取学习动态
     * @return  mixed
    */
    public static function dynamic () {
        return RpcClass::getClass(self::$serviceName, self::$className)->dynamic([]);
    }
    /**
     * 兑换愿望值
     * @return  mixed
    */
    public static function exchangeWishValue (int $wishValue) {
        return RpcClass::getClass(self::$serviceName, self::$className)->exchangeWishValue(["wishValue" => $wishValue]);
    }
    /**
     * 获取积分变更事件
     * @return  mixed
    */
    public static function getChangeLogList () {
        return RpcClass::getClass(self::$serviceName, self::$className)->getChangeLogList([]);
    }
    /**
     * 获取积分类型
     * @return  mixed
    */
    public static function getCreditType () {
        return RpcClass::getClass(self::$serviceName, self::$className)->getCreditType();
    }
    /**
     * 获得排行信息
     * @return  mixed
    */
    public static function getTop (string $itemName) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getTop(["itemName" => $itemName]);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}