<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2024-04-25 10:31:44
 */
namespace Mainto\Bridge\Invokes\TrainingProject\Manage\Staff;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class StaffGroup
 * @method getStaffGroupListByParams(array $params) 用户组列表查询
 * @method createStaffGroupByParams(array $params) 用户组新增
 * @method editStaffGroupByParams(array $params) 用户组更新
 * @method deleteStaffGroupByParams(array $params) 用户组删除
 * @method getGroupsByParams(array $params) 用户组-获取所有用户组基础信息
 * @method getGroupByParams(array $params) 用户组-获取单个用户组信息
 * @method getStaffIdsByGroupRulesByParams(array $params) 通过用户组规则获取对应的用户信息
 * @method getStaffsByStaffIdsByParams(array $params) 通过用户ids获取详情
 */
class StaffGroup {
    private static string $serviceName = "TrainingProject";

    private static string $className = "Manage\\Staff\\StaffGroup";

    /**
     * 用户组列表查询
     * @return  array
    */
    public static function getStaffGroupList () {
        return RpcClass::getClass(self::$serviceName, self::$className)->getStaffGroupList([]);
    }
    /**
     * 用户组新增
     * @return  mixed
    */
    public static function createStaffGroup (string $groupName) {
        return RpcClass::getClass(self::$serviceName, self::$className)->createStaffGroup(["groupName" => $groupName]);
    }
    /**
     * 用户组更新
     * @return  mixed
    */
    public static function editStaffGroup (int $groupId, string $groupName) {
        return RpcClass::getClass(self::$serviceName, self::$className)->editStaffGroup(["groupId" => $groupId, "groupName" => $groupName]);
    }
    /**
     * 用户组删除
     * @return  mixed
    */
    public static function deleteStaffGroup (int $groupId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->deleteStaffGroup(["groupId" => $groupId]);
    }
    /**
     * 用户组-获取所有用户组基础信息
     * @return  mixed
    */
    public static function getGroups () {
        return RpcClass::getClass(self::$serviceName, self::$className)->getGroups();
    }
    /**
     * 用户组-获取单个用户组信息
     * @return  mixed
    */
    public static function getGroup (int $groupId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getGroup(["groupId" => $groupId]);
    }
    /**
     * 通过用户组规则获取对应的用户信息
     * @return  mixed
    */
    public static function getStaffIdsByGroupRules (array $rules) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getStaffIdsByGroupRules(["rules" => $rules]);
    }
    /**
     * 通过用户ids获取详情
     * @return  mixed
    */
    public static function getStaffsByStaffIds (array $staffIds) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getStaffsByStaffIds(["staffIds" => $staffIds]);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}