<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2024-04-25 10:31:44
 */
namespace Mainto\Bridge\Invokes\TrainingProject\Manage;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Category
 * @method createByParams(array $params) 创建分类
 * @method updateByParams(array $params) 修改分类
 * @method deleteByParams(array $params) 删除分类
 * @method getListByPaginateByParams(array $params) 按分页获取分类列表
 * @method getAllListByParams(array $params) 所有匹配的分类列表（不分页）
 * @method getDetailByParams(array $params) 分类详情
 */
class Category {
    private static string $serviceName = "TrainingProject";

    private static string $className = "Manage\\Category";

    /**
     * 创建分类
     * @return  mixed
    */
    public static function create (string $categoryType, string $name) {
        return RpcClass::getClass(self::$serviceName, self::$className)->create(["categoryType" => $categoryType, "name" => $name]);
    }
    /**
     * 修改分类
     * @return  mixed
    */
    public static function update (int $id, string $name, string $categoryType) {
        return RpcClass::getClass(self::$serviceName, self::$className)->update(["id" => $id, "name" => $name, "categoryType" => $categoryType]);
    }
    /**
     * 删除分类
     * @return  mixed
    */
    public static function delete (int $id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->delete(["id" => $id]);
    }
    /**
     * 按分页获取分类列表
     * @return  mixed
    */
    public static function getListByPaginate (string $type) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getListByPaginate(["type" => $type]);
    }
    /**
     * 所有匹配的分类列表（不分页）
     * @return  mixed
    */
    public static function getAllList () {
        return RpcClass::getClass(self::$serviceName, self::$className)->getAllList([]);
    }
    /**
     * 分类详情
     * @return  mixed
    */
    public static function getDetail (int $id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getDetail(["id" => $id]);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}