<?php
namespace Mainto\Bridge\Invokes\TrainingProject\User;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getPracticeTaskListByParams(array $params)
 * @method getAssessmentTaskListByParams(array $params)
 * @method getTaskByParams(array $params)
 * @method getTaskWithExaminationNumByParams(array $params)
 * @method getTaskKnowledgeListByParams(array $params)
 */
class Task {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 练习列表
     *
     * @support  string $name 名称 [ require false ]
     * @support  string $recordType new最新练习\old最近参与 [ require false ]
     * @param  int $page 页码 [ require false ]
     * @param  int $pageSize 每页记录数 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getPracticeTaskList (int $page = 1, int $pageSize = 10) {
        return self::getClass()->getPracticeTaskList([
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * 考核列表
     *
     * @support  string $name 名称 [ require false ]
     * @support  string $recordType new最新练习\old最近参与 [ require false ]
     * @param  int $page 页码 [ require false ]
     * @param  int $pageSize 每页记录数 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getAssessmentTaskList (int $page = 1, int $pageSize = 10) {
        return self::getClass()->getAssessmentTaskList([
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * 详情
     *
     * @param  int $taskId task_id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getTask (int $taskId) {
        return self::getClass()->getTask([
            "taskId" => $taskId,
        ]);
    }

    /**
     * 任务详情（包含题目数量）
     *
     * @param  int $taskId task_id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getTaskWithExaminationNum (int $taskId) {
        return self::getClass()->getTaskWithExaminationNum([
            "taskId" => $taskId,
        ]);
    }

    /**
     * 任务列表.星系研修所
     *
     * @param  int $courseId 课程id [ require true ]
     * @param  int $page 页码 [ require false ]
     * @param  int $pageSize 每页记录数 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getTaskKnowledgeList (int $courseId, int $page = 1, int $pageSize = 10) {
        return self::getClass()->getTaskKnowledgeList([
            "courseId" => $courseId,
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('TrainingProject', 'User\Task');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('TrainingProject', 'User\Task');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}