<?php
namespace Mainto\Bridge\Invokes\TrainingProject\Manage;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method checkQuestionBankNameActiveByParams(array $params)
 * @method addQuestionBankByParams(array $params)
 * @method editQuestionBankByParams(array $params)
 * @method deleteQuestionBankByParams(array $params)
 * @method getQuestionBankListByParams(array $params)
 * @method getQuestionBankByParams(array $params)
 * @method getQuestionBanksByIdsByParams(array $params)
 * @method getQuestionBanksByParams(array $params)
 */
class QuestionBank {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 检测题库名称可用
     *
     * @param  string $name 题库名称 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function checkQuestionBankNameActive (string $name) {
        return self::getClass()->checkQuestionBankNameActive([
            "name" => $name,
        ]);
    }

    /**
     * 创建题库
     *
     * @param  string $name 名称 [ require true ]
     * @param  string $type 类型，修片 retouch，知识问答 knowledge，课程 course [ require true ]
     * @param  string $applyIn 应用于 [ require true ]
     * @param  int $count 题目数量 [ require true ]
     * @param  array $questions 题目 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function addQuestionBank (string $name, string $type, string $applyIn, int $count, array $questions) {
        return self::getClass()->addQuestionBank([
            "name" => $name,
            "type" => $type,
            "applyIn" => $applyIn,
            "count" => $count,
            "questions" => $questions,
        ]);
    }

    /**
     * 修改题库
     *
     * @param  int $id id [ require true ]
     * @support  string $name 名称 [ require false ]
     * @param  string $applyIn 应用于 [ require true ]
     * @support  int $count 题目数量 [ require false ]
     * @support  array $questions 题目 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function editQuestionBank (int $id, string $applyIn) {
        return self::getClass()->editQuestionBank([
            "id" => $id,
            "applyIn" => $applyIn,
        ]);
    }

    /**
     * 删除题库
     *
     * @param  int $id id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function deleteQuestionBank (int $id) {
        return self::getClass()->deleteQuestionBank([
            "id" => $id,
        ]);
    }

    /**
     * 列表
     *
     * @support  string $name 名称 [ require false ]
     * @support  string $type 类型 [ require false ]
     * @support  string $status 状态 [ require false ]
     * @param  int $page 页码 [ require false ]
     * @param  int $pageSize 每页记录数 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getQuestionBankList (int $page = 1, int $pageSize = 10) {
        return self::getClass()->getQuestionBankList([
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * 详情
     *
     * @param  int $id id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getQuestionBank (int $id) {
        return self::getClass()->getQuestionBank([
            "id" => $id,
        ]);
    }

    /**
     * 根据ids获取数据
     *
     * @param  array $questionBankIds ids [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getQuestionBanksByIds (array $questionBankIds) {
        return self::getClass()->getQuestionBanksByIds([
            "questionBankIds" => $questionBankIds,
        ]);
    }

    /**
     * 获取自动生成题库数据
     *
     * @param  string $type 类型，retouch 修片；knowledge 知识问答 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getQuestionBanks (string $type = '') {
        return self::getClass()->getQuestionBanks([
            "type" => $type,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('TrainingProject', 'Manage\QuestionBank');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('TrainingProject', 'Manage\QuestionBank');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}