<?php
namespace Mainto\Bridge\Invokes\TrainingProject\Manage;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createByParams(array $params)
 * @method updateByParams(array $params)
 * @method deleteByParams(array $params)
 * @method getListByPaginateByParams(array $params)
 * @method getAllListByParams(array $params)
 * @method getDetailByParams(array $params)
 */
class Category {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 创建分类
     *
     * @param  string $name 分类名称 [ require true ]
     * @param  string $categoryType 类型 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function create (string $categoryType, string $name) {
        return self::getClass()->create([
            "categoryType" => $categoryType,
            "name" => $name,
        ]);
    }

    /**
     * 修改分类
     *
     * @param  int $id 分类编号 [ require true ]
     * @param  string $name 分类名称 [ require true ]
     * @param  string $categoryType 类型 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function update (int $id, string $name, string $categoryType) {
        return self::getClass()->update([
            "id" => $id,
            "name" => $name,
            "categoryType" => $categoryType,
        ]);
    }

    /**
     * 删除分类
     *
     * @param  int $id 分类编号 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function delete (int $id) {
        return self::getClass()->delete([
            "id" => $id,
        ]);
    }

    /**
     * 按分页获取分类列表
     *
     * @support  string $name 标题 [ require false ]
     * @param  string $type 类型 [ require true ]
     * @param  int $page 页码 [ require false ]
     * @param  int $pageSize 每页记录数 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getListByPaginate (string $type, int $page = 1, int $pageSize = 10) {
        return self::getClass()->getListByPaginate([
            "type" => $type,
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * 所有匹配的分类列表（不分页）
     *
     * @support  string $name 标题 [ require false ]
     * @support  string $type 类型 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getAllList () {
        return self::getClass()->getAllList([
        ]);
    }

    /**
     * 分类详情
     *
     * @param  int $id 分类 id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getDetail (int $id) {
        return self::getClass()->getDetail([
            "id" => $id,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('TrainingProject', 'Manage\Category');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('TrainingProject', 'Manage\Category');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}