<?php
namespace Mainto\Bridge\Invokes\TrainingProject\User;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getCourseCompulsoryListByParams(array $params)
 * @method getCourseListWithStatusByParams(array $params)
 * @method getNextCourseByCourseIdByParams(array $params)
 * @method getCourseByIdByParams(array $params)
 * @method getCourseNamesByCourseIdsByParams(array $params)
 * @method submitAnswerByParams(array $params)
 * @method remarkCourseDoneByParams(array $params)
 * @method updateCourseScheduleExtendByParams(array $params)
 * @method getMessageListByParams(array $params)
 * @method readByParams(array $params)
 * @method onStaffUpdateByParams(array $params)
 */
class Course {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 课程（必修，选修，最新）.列表
     *
     * @support  string $name 课程名称 [ require false ]
     * @support  int $categoryId 课程分类id [ require false ]
     * @support  string $studyType 课程类型，选修 not_compulsory，必修 compulsory [ require false ]
     * @param  int $page 页码 [ require false ]
     * @param  int $pageSize 每页记录数 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getCourseCompulsoryList (int $page = 1, int $pageSize = 10) {
        return self::getClass()->getCourseCompulsoryList([
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * 课程（进行中，待学习）.列表
     *
     * @support  string $name 课程名称 [ require false ]
     * @support  int $categoryId 课程分类id [ require false ]
     * @support  string $studyType 课程类型，选修 not_compulsory，必修 compulsory [ require false ]
     * @support  string $scheduleStatus 课程记录状态，learning 进行中；不传为未学习 [ require false ]
     * @param  int $page 页码 [ require false ]
     * @param  int $pageSize 每页记录数 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getCourseListWithStatus (int $page = 1, int $pageSize = 10) {
        return self::getClass()->getCourseListWithStatus([
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * 课程.下一门课程
     *
     * @param  int $courseId 当前课程id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getNextCourseByCourseId (int $courseId) {
        return self::getClass()->getNextCourseByCourseId([
            "courseId" => $courseId,
        ]);
    }

    /**
     * 课程.单个详情
     *
     * @param  int $id id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getCourseById (int $id) {
        return self::getClass()->getCourseById([
            "id" => $id,
        ]);
    }

    /**
     * 课程.通过课程ids获得课程名
     *
     * @param  array $courseIds 课程ids [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getCourseNamesByCourseIds (array $courseIds = []) {
        return self::getClass()->getCourseNamesByCourseIds([
            "courseIds" => $courseIds,
        ]);
    }

    /**
     * 提交课程小节题答案
     *
     * @param  int $courseId 课程 id [ require true ]
     * @param  int $staffId 伙伴 id [ require true ]
     * @param  int $questionId 问题 id [ require true ]
     * @param  mixed $answerInfo 回答的信息 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function submitAnswer (int $courseId, int $staffId, int $questionId, $answerInfo) {
        return self::getClass()->submitAnswer([
            "courseId" => $courseId,
            "staffId" => $staffId,
            "questionId" => $questionId,
            "answerInfo" => $answerInfo,
        ]);
    }

    /**
     * 课程.课程内容已学完
     *
     * @param  int $id 课程id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function remarkCourseDone (int $id) {
        return self::getClass()->remarkCourseDone([
            "id" => $id,
        ]);
    }

    /**
     * 课程.课程学习时间记录
     *
     * @param  int $id 课程id [ require true ]
     * @param  array $extend 时间记录值数组 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function updateCourseScheduleExtend (int $id, array $extend) {
        return self::getClass()->updateCourseScheduleExtend([
            "id" => $id,
            "extend" => $extend,
        ]);
    }

    /**
     * 课程.获取员工提醒
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function getMessageList () {
        return self::getClass()->getMessageList();
    }

    /**
     * 课程.设为已读
     *
     * @param  int $id 消息id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function read (int $id) {
        return self::getClass()->read([
            "id" => $id,
        ]);
    }

    /**
     * 员工信息变更
     *
     * @throws  \Exception
     * @return  void
     */
    public static function onStaffUpdate () {
        return self::getClass()->onStaffUpdate();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('TrainingProject', 'User\Course');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('TrainingProject', 'User\Course');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}