<?php
namespace Mainto\Bridge\Invokes\TrainingProject\User;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method addByParams(array $params)
 * @method deleteByParams(array $params)
 * @method likeByParams(array $params)
 * @method cancelLikeByParams(array $params)
 * @method replyByParams(array $params)
 * @method getReplyListByParams(array $params)
 * @method getCommentListByParams(array $params)
 */
class Comment {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 添加留言
     *
     * @param  int $relationId 关联id:课程/案例 [ require true ]
     * @param  string $type 类型:课程/案例（英文） [ require true ]
     * @param  string $comment 内容 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function add (int $relationId, string $type, string $comment) {
        return self::getClass()->add([
            "relationId" => $relationId,
            "type" => $type,
            "comment" => $comment,
        ]);
    }

    /**
     * 删除留言回复
     *
     * @param  int $id 留言回复的 id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function delete (int $id) {
        return self::getClass()->delete([
            "id" => $id,
        ]);
    }

    /**
     * 点赞
     *
     * @param  int $commentId 留言信息 id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function like (int $commentId) {
        return self::getClass()->like([
            "commentId" => $commentId,
        ]);
    }

    /**
     * 取消点赞
     *
     * @param  int $commentId 留言信息 id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function cancelLike (int $commentId) {
        return self::getClass()->cancelLike([
            "commentId" => $commentId,
        ]);
    }

    /**
     * 添加回复
     *
     * @param  int $relationId 关联id:课程/案例 [ require true ]
     * @param  string $type 类型:课程/案例（英文） [ require true ]
     * @param  int $topCommentId 留言的 id [ require true ]
     * @param  int $parentId 被回复的信息id [ require true ]
     * @param  int $toStaffId 被回复的伙伴工号id [ require true ]
     * @param  string $comment 回复内容（限制 255字以内） [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function reply (int $relationId, string $type, int $topCommentId, int $parentId, int $toStaffId, string $comment) {
        return self::getClass()->reply([
            "relationId" => $relationId,
            "type" => $type,
            "topCommentId" => $topCommentId,
            "parentId" => $parentId,
            "toStaffId" => $toStaffId,
            "comment" => $comment,
        ]);
    }

    /**
     * 按分页获取回复列表
     *
     * @param  int $topCommentId 留言的 id [ require true ]
     * @param  int $page 页码 [ require false ]
     * @param  int $pageSize 每页记录数 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getReplyList (int $topCommentId, int $page = 1, int $pageSize = 10) {
        return self::getClass()->getReplyList([
            "topCommentId" => $topCommentId,
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * 按分页获取留言列表
     *
     * @param  int $relationId 关联id:课程/案例 [ require true ]
     * @param  string $type 类型:课程/案例（英文） [ require true ]
     * @param  int $page 页码 [ require false ]
     * @param  int $pageSize 每页记录数 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getCommentList (int $relationId, string $type, int $page = 1, int $pageSize = 10) {
        return self::getClass()->getCommentList([
            "relationId" => $relationId,
            "type" => $type,
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('TrainingProject', 'User\Comment');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('TrainingProject', 'User\Comment');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}