<?php
namespace Mainto\Bridge\Invokes\TrainingProject\Manage\RBAC;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getAdminListByParams(array $params)
 * @method addAdminByParams(array $params)
 * @method updateAdminByParams(array $params)
 * @method updateServicePermissionStoreByParams(array $params)
 * @method updateProductPermissionStoreByParams(array $params)
 * @method deleteAdminByParams(array $params)
 * @method onStaffDeletedByParams(array $params)
 * @method getPermissionsByParams(array $params)
 * @method loginDetailByParams(array $params)
 */
class Admin {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 管理员列表
     *
     * @param  array $staffIds 工号组 [ require false ]
     * @param  int $page 页码 [ require false ]
     * @param  int $pageSize 每页条数 [ require false ]
     * @throws  \Exception
     * @return  array
     */
    public static function getAdminList (array $staffIds = [], int $page = 1, int $pageSize = 10) {
        return self::getClass()->getAdminList([
            "staffIds" => $staffIds,
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * 管理员新增
     *
     * @param  int $staffId 工号 [ require true ]
     * @param  array $permissionIds 权限组 [ require false ]
     * @param  array $departmentPermissions 部门ids [ require false ]
     * @param  array $storePermissions 技术通关管理门店ids [ require false ]
     * @param  array $statsPermissions 数据统计部门ids [ require false ]
     * @param  string $storeType 是否督导，是 值为manager，否 值为staff [ require false ]
     * @param  array $studyPermissions 学习明细部门ids [ require false ]
     * @param  array $qualityPermissions 课程质量部门ids [ require false ]
     * @param  array $servicePermissions 课程质量部门ids [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function addAdmin (int $staffId, array $permissionIds = [], array $departmentPermissions = [], array $storePermissions = [], string $storeType = 'staff', array $statsPermissions = [], array $studyPermissions = [], array $qualityPermissions = [], array $servicePermissions = []) {
        return self::getClass()->addAdmin([
            "staffId" => $staffId,
            "permissionIds" => $permissionIds,
            "departmentPermissions" => $departmentPermissions,
            "storePermissions" => $storePermissions,
            "storeType" => $storeType,
            "statsPermissions" => $statsPermissions,
            "studyPermissions" => $studyPermissions,
            "qualityPermissions" => $qualityPermissions,
            "servicePermissions" => $servicePermissions,
        ]);
    }

    /**
     * 管理员更新
     *
     * @param  int $staffId 工号 [ require true ]
     * @param  array $permissionIds 权限组 [ require false ]
     * @param  array $departmentPermissions 部门ids [ require false ]
     * @param  array $storePermissions 技术通关管理门店ids [ require false ]
     * @param  array $statsPermissions 数据统计部门ids [ require false ]
     * @param  string $storeType 是否督导，是 值为manager，否 值为staff [ require false ]
     * @param  array $studyPermissions 学习明细部门ids [ require false ]
     * @param  array $qualityPermissions 课程质量部门ids [ require false ]
     * @param  array $servicePermissions 服务通关部门ids [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function updateAdmin (int $staffId, array $permissionIds = [], array $departmentPermissions = [], array $storePermissions = [], string $storeType = 'staff', array $statsPermissions = [], array $studyPermissions = [], array $qualityPermissions = [], array $servicePermissions = []) {
        return self::getClass()->updateAdmin([
            "staffId" => $staffId,
            "permissionIds" => $permissionIds,
            "departmentPermissions" => $departmentPermissions,
            "storePermissions" => $storePermissions,
            "storeType" => $storeType,
            "statsPermissions" => $statsPermissions,
            "studyPermissions" => $studyPermissions,
            "qualityPermissions" => $qualityPermissions,
            "servicePermissions" => $servicePermissions,
        ]);
    }

    /**
     * 更新服务通关的门店管辖范围
     *
     * @param  int $staffId 工号 [ require true ]
     * @param  array $servicePermissions 服务通关部门ids [ require false ]
     * @throws  \Exception
     * @return  bool
     */
    public static function updateServicePermissionStore (int $staffId, array $servicePermissions = []) {
        return self::getClass()->updateServicePermissionStore([
            "staffId" => $staffId,
            "servicePermissions" => $servicePermissions,
        ]);
    }

    /**
     * 更新技术通关的门店管辖范围
     *
     * @param  int $staffId 工号 [ require true ]
     * @param  array $storePermissions 技术通关管理门店ids [ require false ]
     * @param  string $storeType 是否督导，是 值为manager，否 值为staff [ require false ]
     * @throws  \Exception
     * @return  bool
     */
    public static function updateProductPermissionStore (int $staffId, array $storePermissions = [], string $storeType = 'staff') {
        return self::getClass()->updateProductPermissionStore([
            "staffId" => $staffId,
            "storePermissions" => $storePermissions,
            "storeType" => $storeType,
        ]);
    }

    /**
     * 管理员删除
     *
     * @param  int $staffId 工号 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function deleteAdmin (int $staffId) {
        return self::getClass()->deleteAdmin([
            "staffId" => $staffId,
        ]);
    }

    /**
     * 通过 hook 执行这儿的伙伴移除， 集群网关触发默认执行，需要有这儿的功能保留
     *
     * @param  int $staff_id 伙伴id [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function onStaffDeleted (int $staff_id) {
        return self::getClass()->onStaffDeleted([
            "staff_id" => $staff_id,
        ]);
    }

    /**
     * 获取单个管理员拥有的所有权限
     *
     * @param  int $staffId 工号 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getPermissions (int $staffId) {
        return self::getClass()->getPermissions([
            "staffId" => $staffId,
        ]);
    }

    /**
     * 管理员登录个人和权限信息
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function loginDetail () {
        return self::getClass()->loginDetail();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('TrainingProject', 'Manage\RBAC\Admin');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('TrainingProject', 'Manage\RBAC\Admin');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}