<?php
namespace Mainto\Bridge\Invokes\TrainingProject\Manage;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getCaseListByParams(array $params)
 * @method addCaseByParams(array $params)
 * @method editCaseByParams(array $params)
 * @method getCaseByIdByParams(array $params)
 * @method deleteCaseByParams(array $params)
 * @method onlineCaseByParams(array $params)
 * @method getCaseListWithReadByParams(array $params)
 * @method createByParams(array $params)
 * @method listByParams(array $params)
 * @method deleteByParams(array $params)
 */
class Case {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 案例.列表分页
     *
     * @support  int $categoryId 案例分类id [ require false ]
     * @support  string $title 标题 [ require false ]
     * @support  string $publishBeginDate 发布开始日期 [ require false ]
     * @support  string $publishEndDate 发布结束日期 [ require false ]
     * @param  int $page 页码 [ require false ]
     * @param  int $pageSize 每页记录数 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getCaseList (int $page = 1, int $pageSize = 10) {
        return self::getClass()->getCaseList([
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * 案例.新增
     *
     * @support  string $title 标题 [ require false ]
     * @support  int $categoryId 案例分类id [ require false ]
     * @support  string $source 来源 [ require false ]
     * @support  string $coverPicture 封面图地址 [ require false ]
     * @support  string $description 描述 [ require false ]
     * @support  array $groupIds 用户组数组 [ require false ]
     * @support  string $status 状态，offline, online [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function addCase () {
        return self::getClass()->addCase([
        ]);
    }

    /**
     * 案例.编辑
     *
     * @support  int $id id [ require true ]
     * @support  string $title 标题 [ require false ]
     * @support  int $categoryId 案例分类id [ require false ]
     * @support  string $source 来源 [ require false ]
     * @support  string $coverPicture 封面图地址 [ require false ]
     * @support  string $description 描述 [ require false ]
     * @support  array $groupIds 用户组数组 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function editCase () {
        return self::getClass()->editCase([
        ]);
    }

    /**
     * 案例.单个详情
     *
     * @param  int $id id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getCaseById (int $id) {
        return self::getClass()->getCaseById([
            "id" => $id,
        ]);
    }

    /**
     * 案例.删除
     *
     * @param  int $id id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function deleteCase (int $id) {
        return self::getClass()->deleteCase([
            "id" => $id,
        ]);
    }

    /**
     * 案例.上下线
     *
     * @param  int $id id [ require true ]
     * @param  string $status 状态，offline, online [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function onlineCase (int $id, string $status) {
        return self::getClass()->onlineCase([
            "id" => $id,
            "status" => $status,
        ]);
    }

    /**
     * 案例.学习明细.列表分页
     *
     * @param  string $title 标题 [ require false ]
     * @param  int $page 页码 [ require false ]
     * @param  int $pageSize 每页记录数 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getCaseListWithRead (string $title = '', int $page = 1, int $pageSize = 10) {
        return self::getClass()->getCaseListWithRead([
            "title" => $title,
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * 案例.学习明细.下载.新增导出任务
     *
     * @support  string $template_id 模板id [ require false ]
     * @support  array $params 参数, [caseId:1] [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function create () {
        return self::getClass()->create([
        ]);
    }

    /**
     * 案例.学习明细.下载.获取列表分页
     *
     * @support  string $template_id 导出模板id [ require false ]
     * @support  int $page 页码 [ require false ]
     * @support  int $page_size 每页数量 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function list () {
        return self::getClass()->list([
        ]);
    }

    /**
     * 案例.学习明细.下载.删除记录
     *
     * @support  array $task_ids 任务ids [ require false ]
     * @support  array $template_ids 模板ids [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function delete () {
        return self::getClass()->delete([
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('TrainingProject', 'Manage\Case');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('TrainingProject', 'Manage\Case');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}