<?php
namespace Mainto\Bridge\Invokes\TrainingProject\User;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method everyDateCountByParams(array $params)
 * @method everyMonthCountByParams(array $params)
 */
class Carbon {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 定时任务 统计每日学习信息
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function everyDateCount () {
        return self::getClass()->everyDateCount();
    }

    /**
     * 门店培训 定时任务 统计每月学习信息 排行榜
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function everyMonthCount () {
        return self::getClass()->everyMonthCount();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('TrainingProject', 'User\Carbon');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('TrainingProject', 'User\Carbon');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}